/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.net.URLEncoder;
import java.util.Objects;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.service.WxOAuth2Service;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import me.chanjar.weixin.open.api.WxOpenMpService;
import me.chanjar.weixin.open.api.impl.WxOpenMpOAuth2ServiceImpl;
import me.chanjar.weixin.open.bean.mp.FastRegisterResult;
import me.chanjar.weixin.open.bean.result.WxAmpLinkResult;
import me.chanjar.weixin.open.bean.result.WxOpenResult;

public class WxOpenMpServiceImpl
extends WxMpServiceImpl
implements WxOpenMpService {
    private WxOpenComponentService wxOpenComponentService;
    private WxMpConfigStorage wxMpConfigStorage;
    private String appId;

    public WxOpenMpServiceImpl(WxOpenComponentService wxOpenComponentService, String appId, WxMpConfigStorage wxMpConfigStorage) {
        this.wxOpenComponentService = wxOpenComponentService;
        this.appId = appId;
        this.wxMpConfigStorage = wxMpConfigStorage;
        this.setOAuth2Service((WxOAuth2Service)new WxOpenMpOAuth2ServiceImpl(wxOpenComponentService, this.getOAuth2Service(), wxMpConfigStorage));
        this.initHttp();
    }

    public WxMpConfigStorage getWxMpConfigStorage() {
        return this.wxMpConfigStorage;
    }

    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        return this.wxOpenComponentService.getAuthorizerAccessToken(this.appId, forceRefresh);
    }

    @Override
    public String getFastRegisterAuthUrl(String redirectUri, Boolean copyWxVerify) {
        String copyInfo = Objects.equals(copyWxVerify, false) ? "0" : "1";
        String componentAppId = this.wxOpenComponentService.getWxOpenConfigStorage().getComponentAppId();
        String encoded = URLEncoder.encode(redirectUri, "UTF-8");
        return String.format("https://mp.weixin.qq.com/cgi-bin/fastregisterauth?appid=%s&component_appid=%s&copy_wx_verify=%s&redirect_uri=%s", this.appId, componentAppId, copyInfo, encoded);
    }

    @Override
    public FastRegisterResult fastRegister(String ticket) throws WxErrorException {
        String json = this.post("https://api.weixin.qq.com/cgi-bin/account/fastregister", ImmutableMap.of((Object)"ticket", (Object)ticket));
        return FastRegisterResult.fromJson(json);
    }

    @Override
    public WxAmpLinkResult getWxAmpLink() throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/wxamplinkget", "{}");
        return (WxAmpLinkResult)WxMaGsonBuilder.create().fromJson(response, WxAmpLinkResult.class);
    }

    @Override
    public WxOpenResult wxAmpLink(String appid, String notifyUsers, String showProfile) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("appid", appid);
        params.addProperty("notify_users", notifyUsers);
        params.addProperty("show_profile", showProfile);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/wxamplink", params.toString());
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult wxAmpUnLink(String appid) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("appid", appid);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/wxampunlink", params.toString());
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }
}

