/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.ecommerce.FundBalanceResult;
import com.github.binarywang.wxpay.bean.ecommerce.enums.SpAccountTypeEnum;
import com.github.binarywang.wxpay.bean.marketing.transfer.BatchDetailsResult;
import com.github.binarywang.wxpay.bean.marketing.transfer.BatchNumberRequest;
import com.github.binarywang.wxpay.bean.marketing.transfer.BatchNumberResult;
import com.github.binarywang.wxpay.bean.marketing.transfer.BillReceiptResult;
import com.github.binarywang.wxpay.bean.marketing.transfer.ElectronicReceiptsRequest;
import com.github.binarywang.wxpay.bean.marketing.transfer.ElectronicReceiptsResult;
import com.github.binarywang.wxpay.bean.marketing.transfer.MerchantBatchRequest;
import com.github.binarywang.wxpay.bean.marketing.transfer.PartnerTransferRequest;
import com.github.binarywang.wxpay.bean.marketing.transfer.PartnerTransferResult;
import com.github.binarywang.wxpay.bean.marketing.transfer.ReceiptBillRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.PartnerTransferService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartnerTransferServiceImpl
implements PartnerTransferService {
    private static final Logger log = LoggerFactory.getLogger(PartnerTransferServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public PartnerTransferResult batchTransfer(PartnerTransferRequest request) throws WxPayException {
        request.getTransferDetailList().forEach(p -> {
            try {
                String userName = RsaCryptoUtil.encryptOAEP(p.getUserName(), this.payService.getConfig().getVerifier().getValidCertificate());
                p.setUserName(userName);
                if (StringUtil.isNotBlank((CharSequence)p.getUserIdCard())) {
                    String userIdCard = RsaCryptoUtil.encryptOAEP(p.getUserIdCard(), this.payService.getConfig().getVerifier().getValidCertificate());
                    p.setUserIdCard(userIdCard);
                }
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException("\u59d3\u540d\u6216\u8eab\u4efd\u8bc1\u8f6c\u6362\u5f02\u5e38!", e);
            }
        });
        String url = String.format("%s/v3/partner-transfer/batches", this.payService.getPayBaseUrl());
        String response = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (PartnerTransferResult)GSON.fromJson(response, PartnerTransferResult.class);
    }

    @Override
    public BatchNumberResult queryBatchByBatchId(BatchNumberRequest request) throws WxPayException {
        String url = String.format("%s/v3/partner-transfer/batches/batch-id/%s", this.payService.getPayBaseUrl(), request.getBatchId());
        if (request.getOffset() == null) {
            request.setOffset(0);
        }
        if (request.getLimit() == null || request.getLimit() <= 0) {
            request.setLimit(20);
        }
        String detailStatus = StringUtil.isNotBlank((CharSequence)request.getDetailStatus()) ? request.getDetailStatus() : "ALL";
        String query = String.format("?need_query_detail=%s&detail_status=%s&offset=%s&limit=%s", request.getNeedQueryDetail(), detailStatus, request.getOffset(), request.getLimit());
        String response = this.payService.getV3(url + query);
        return (BatchNumberResult)GSON.fromJson(response, BatchNumberResult.class);
    }

    @Override
    public BatchNumberResult queryBatchByOutBatchNo(MerchantBatchRequest request) throws WxPayException {
        String url = String.format("%s/v3/partner-transfer/batches/out-batch-no/%s", this.payService.getPayBaseUrl(), request.getOutBatchNo());
        if (request.getOffset() == null) {
            request.setOffset(0);
        }
        if (request.getLimit() == null || request.getLimit() <= 0) {
            request.setLimit(20);
        }
        String query = String.format("?need_query_detail=%s&offset=%s&limit=%s", request.getNeedQueryDetail(), request.getOffset(), request.getLimit());
        if (StringUtil.isNotBlank((CharSequence)request.getDetailStatus())) {
            query = query + "&detail_status=" + request.getDetailStatus();
        }
        String response = this.payService.getV3(url + query);
        return (BatchNumberResult)GSON.fromJson(response, BatchNumberResult.class);
    }

    @Override
    public BatchDetailsResult queryBatchDetailByWeChat(String batchId, String detailId) throws WxPayException, BadPaddingException {
        String url = String.format("%s/v3/partner-transfer/batches/batch-id/%s/details/detail-id/%s", this.payService.getPayBaseUrl(), batchId, detailId);
        String response = this.payService.getV3(url);
        BatchDetailsResult batchDetailsResult = (BatchDetailsResult)GSON.fromJson(response, BatchDetailsResult.class);
        String userName = RsaCryptoUtil.decryptOAEP(batchDetailsResult.getUserName(), this.payService.getConfig().getPrivateKey());
        batchDetailsResult.setUserName(userName);
        return batchDetailsResult;
    }

    @Override
    public BatchDetailsResult queryBatchDetailByMch(String outBatchNo, String outDetailNo) throws WxPayException, BadPaddingException {
        String url = String.format("%s/v3/partner-transfer/batches/out-batch-no/%s/details/out-detail-no/%s", this.payService.getPayBaseUrl(), outBatchNo, outDetailNo);
        String response = this.payService.getV3(url);
        BatchDetailsResult batchDetailsResult = (BatchDetailsResult)GSON.fromJson(response, BatchDetailsResult.class);
        String userName = RsaCryptoUtil.decryptOAEP(batchDetailsResult.getUserName(), this.payService.getConfig().getPrivateKey());
        batchDetailsResult.setUserName(userName);
        return batchDetailsResult;
    }

    @Override
    public BillReceiptResult receiptBill(ReceiptBillRequest request) throws WxPayException {
        String url = String.format("%s/v3/transfer/bill-receipt", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (BillReceiptResult)GSON.fromJson(response, BillReceiptResult.class);
    }

    @Override
    public BillReceiptResult queryBillReceipt(String outBatchNo) throws WxPayException {
        String url = String.format("%s/v3/transfer/bill-receipt/%s", this.payService.getPayBaseUrl(), outBatchNo);
        String response = this.payService.getV3(url);
        return (BillReceiptResult)GSON.fromJson(response, BillReceiptResult.class);
    }

    @Override
    public ElectronicReceiptsResult transferElectronic(ElectronicReceiptsRequest request) throws WxPayException {
        String url = String.format("%s/v3/transfer-detail/electronic-receipts", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (ElectronicReceiptsResult)GSON.fromJson(response, ElectronicReceiptsResult.class);
    }

    @Override
    public ElectronicReceiptsResult queryTransferElectronicResult(ElectronicReceiptsRequest request) throws WxPayException {
        String url = String.format("%s/v3/transfer-detail/electronic-receipts", this.payService.getPayBaseUrl());
        String query = String.format("?accept_type=%s&out_batch_no=%s&out_detail_no=%s", request.getAcceptType(), request.getOutBatchNo(), request.getOutDetailNo());
        String response = this.payService.getV3(url + query);
        return (ElectronicReceiptsResult)GSON.fromJson(response, ElectronicReceiptsResult.class);
    }

    @Override
    public InputStream transferDownload(String url) throws WxPayException {
        InputStream response = this.payService.downloadV3(url);
        return response;
    }

    @Override
    public FundBalanceResult fundBalance(SpAccountTypeEnum accountType) throws WxPayException {
        String url = String.format("%s/v3/merchant/fund/balance/%s", new Object[]{this.payService.getPayBaseUrl(), accountType});
        String response = this.payService.getV3(url);
        return (FundBalanceResult)GSON.fromJson(response, FundBalanceResult.class);
    }

    @Override
    public FundBalanceResult spDayEndBalance(SpAccountTypeEnum accountType, String date) {
        try {
            return this.payService.getEcommerceService().spDayEndBalance(accountType, date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PartnerTransferServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

