/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.customs.DeclarationQueryRequest;
import com.github.binarywang.wxpay.bean.customs.DeclarationQueryResult;
import com.github.binarywang.wxpay.bean.customs.DeclarationRequest;
import com.github.binarywang.wxpay.bean.customs.DeclarationResult;
import com.github.binarywang.wxpay.bean.customs.RedeclareRequest;
import com.github.binarywang.wxpay.bean.customs.RedeclareResult;
import com.github.binarywang.wxpay.bean.customs.VerifyCertificateRequest;
import com.github.binarywang.wxpay.bean.customs.VerifyCertificateResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.CustomDeclarationService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import me.chanjar.weixin.common.error.WxRuntimeException;

public class CustomDeclarationServiceImpl
implements CustomDeclarationService {
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public DeclarationResult declare(DeclarationRequest request) throws WxPayException {
        String response = this.payService.postV3("https://apihk.mch.weixin.qq.com/global/v3/customs".concat("/orders"), GSON.toJson((Object)request));
        return (DeclarationResult)GSON.fromJson(response, DeclarationResult.class);
    }

    @Override
    public DeclarationQueryResult query(DeclarationQueryRequest request) throws WxPayException {
        String url = String.format("%s/orders?appid=%s&mchid=%s&order_type=%s&order_no=%s&customs=%s&offset=%s&limit=%s", "https://apihk.mch.weixin.qq.com/global/v3/customs", request.getAppid(), request.getMchid(), request.getOrderType(), request.getOrderNo(), request.getCustoms(), request.getOffset(), request.getLimit());
        String result = this.payService.getV3(url);
        return (DeclarationQueryResult)GSON.fromJson(result, DeclarationQueryResult.class);
    }

    @Override
    public VerifyCertificateResult verifyCertificate(VerifyCertificateRequest request) throws WxPayException {
        this.encryptFields(request);
        String response = this.payService.postV3WithWechatpaySerial("https://apihk.mch.weixin.qq.com/global/v3/customs".concat("/verify-certificate"), GSON.toJson((Object)request));
        return (VerifyCertificateResult)GSON.fromJson(response, VerifyCertificateResult.class);
    }

    @Override
    public DeclarationResult modify(DeclarationRequest request) throws WxPayException {
        String response = this.payService.patchV3("https://apihk.mch.weixin.qq.com/global/v3/customs".concat("/orders"), GSON.toJson((Object)request));
        return (DeclarationResult)GSON.fromJson(response, DeclarationResult.class);
    }

    @Override
    public RedeclareResult redeclare(RedeclareRequest request) throws WxPayException {
        String response = this.payService.postV3("https://apihk.mch.weixin.qq.com/global/v3/customs".concat("/redeclare"), GSON.toJson((Object)request));
        return (RedeclareResult)GSON.fromJson(response, RedeclareResult.class);
    }

    private void encryptFields(VerifyCertificateRequest request) throws WxPayException {
        try {
            request.setCertificateId(this.encryptOAEP(request.getCertificateId()));
            request.setCertificateName(this.encryptOAEP(request.getCertificateName()));
        }
        catch (Exception e) {
            throw new WxPayException("\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private X509Certificate getValidCertificate() {
        return this.payService.getConfig().getVerifier().getValidCertificate();
    }

    private String encryptOAEP(String message) throws IllegalBlockSizeException {
        X509Certificate certificate = this.getValidCertificate();
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, certificate.getPublicKey());
            byte[] data = message.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertext = cipher.doFinal(data);
            return Base64.getEncoder().encodeToString(ciphertext);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new WxRuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
    }

    public CustomDeclarationServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

