/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.ecommerce.SignatureHeader;
import com.github.binarywang.wxpay.bean.payscore.PartnerUserSignPlanEntity;
import com.github.binarywang.wxpay.bean.payscore.PayScoreNotifyData;
import com.github.binarywang.wxpay.bean.payscore.WxPartnerPayScoreSignPlanRequest;
import com.github.binarywang.wxpay.bean.payscore.WxPartnerPayScoreSignPlanResult;
import com.github.binarywang.wxpay.bean.payscore.WxPartnerPayScoreUserSignPlanResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.PartnerPayScoreSignPlanService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Objects;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PartnerPayScoreSignPlanServiceImpl
implements PartnerPayScoreSignPlanService {
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public WxPartnerPayScoreSignPlanResult createPlans(WxPartnerPayScoreSignPlanRequest request) throws WxPayException {
        String url = String.format("%s/v3/payscore/plan/partner/payscore-plans", this.payService.getPayBaseUrl());
        if (StringUtils.isBlank((CharSequence)request.getAppid())) {
            request.setAppid(this.payService.getConfig().getAppId());
        }
        if (StringUtils.isBlank((CharSequence)request.getServiceId())) {
            request.setServiceId(this.payService.getConfig().getServiceId());
        }
        String result = this.payService.postV3(url, request.toJson());
        return WxPartnerPayScoreSignPlanResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreSignPlanResult queryPlans(@NonNull String merchantPlanNo, @NonNull String subMchid) throws WxPayException {
        String url = String.format("%s/v3/payscore/plan/partner/payscore-plans/merchant-plan-no/%s", this.payService.getPayBaseUrl(), merchantPlanNo);
        try {
            URI uri = new URIBuilder(url).setParameter("sub_mchid", subMchid).build();
            String result = this.payService.getV3(uri.toString());
            return WxPartnerPayScoreSignPlanResult.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPartnerPayScoreSignPlanResult stopPlans(@NonNull String merchantPlanNo, @NonNull String subMchid) throws WxPayException {
        String url = String.format("%s/v3/payscore/plan/partner/payscore-plans/merchant-plan-no/%s/stop", this.payService.getPayBaseUrl(), merchantPlanNo);
        HashMap params = Maps.newHashMap();
        params.put("sub_mchid", subMchid);
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson((Object)params));
        return WxPartnerPayScoreSignPlanResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreSignPlanResult signPlanServiceOrder(WxPartnerPayScoreSignPlanRequest request) throws WxPayException {
        String url = String.format("%s/v3/payscore/sign-plan/partner/serviceorder", this.payService.getPayBaseUrl());
        if (StringUtils.isBlank((CharSequence)request.getAppid())) {
            request.setAppid(this.payService.getConfig().getAppId());
        }
        if (StringUtils.isBlank((CharSequence)request.getServiceId())) {
            request.setServiceId(this.payService.getConfig().getServiceId());
        }
        String result = this.payService.postV3(url, request.toJson());
        return WxPartnerPayScoreSignPlanResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreUserSignPlanResult createUserSignPlans(WxPartnerPayScoreSignPlanRequest request) throws WxPayException {
        String url = String.format("%s/v3/payscore/sign-plan/partner/user-sign-plans", this.payService.getPayBaseUrl());
        if (StringUtils.isBlank((CharSequence)request.getAppid())) {
            request.setAppid(this.payService.getConfig().getAppId());
        }
        if (StringUtils.isBlank((CharSequence)request.getServiceId())) {
            request.setServiceId(this.payService.getConfig().getServiceId());
        }
        String result = this.payService.postV3(url, request.toJson());
        return WxPartnerPayScoreUserSignPlanResult.fromJson(result);
    }

    @Override
    public PartnerUserSignPlanEntity queryUserSignPlans(@NonNull String merchantSignPlanNo, @NonNull String subMchid) throws WxPayException {
        String url = String.format("%s/v3/payscore/sign-plan/partner/user-sign-plans/merchant-sign-plan-no/%s", this.payService.getPayBaseUrl(), merchantSignPlanNo);
        try {
            URI uri = new URIBuilder(url).setParameter("sub_mchid", subMchid).build();
            String result = this.payService.getV3(uri.toString());
            return PartnerUserSignPlanEntity.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public PartnerUserSignPlanEntity stopUserSignPlans(@NonNull String merchantSignPlanNo, @NonNull String subMchid, @NonNull String stopReason) throws WxPayException {
        String url = String.format("%s/v3/payscore/sign-plan/partner/user-sign-plans/merchant-sign-plan-no/%s/stop", this.payService.getPayBaseUrl(), merchantSignPlanNo);
        HashMap params = Maps.newHashMap();
        params.put("sub_mchid", subMchid);
        params.put("stop_reason", stopReason);
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson((Object)params));
        return PartnerUserSignPlanEntity.fromJson(result);
    }

    @Override
    public PartnerUserSignPlanEntity parseSignPlanNotifyResult(String notifyData, SignatureHeader header) throws WxPayException {
        PayScoreNotifyData response = this.parseNotifyData(notifyData, header);
        return this.decryptNotifyDataResource(response);
    }

    public PayScoreNotifyData parseNotifyData(String data, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, data)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        return (PayScoreNotifyData)GSON.fromJson(data, PayScoreNotifyData.class);
    }

    public PartnerUserSignPlanEntity decryptNotifyDataResource(PayScoreNotifyData data) throws WxPayException {
        PayScoreNotifyData.Resource resource = data.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            return PartnerUserSignPlanEntity.fromJson(AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    private boolean verifyNotifySign(SignatureHeader header, String data) {
        String beforeSign = String.format("%s\n%s\n%s\n", header.getTimeStamp(), header.getNonce(), data);
        return this.payService.getConfig().getVerifier().verify(header.getSerialNo(), beforeSign.getBytes(StandardCharsets.UTF_8), header.getSigned());
    }

    public PartnerPayScoreSignPlanServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

