/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfPictureList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RtfListTable
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST_TABLE = DocWriter.getISOBytes((String)"\\*\\listtable");
    private static final byte[] LIST_OVERRIDE_TABLE = DocWriter.getISOBytes((String)"\\*\\listoverridetable");
    private static final byte[] LIST_OVERRIDE = DocWriter.getISOBytes((String)"\\listoverride");
    private static final byte[] LIST_OVERRIDE_COUNT = DocWriter.getISOBytes((String)"\\listoverridecount");
    private final List<RtfList> lists = new ArrayList<RtfList>();
    private final List<RtfPictureList> picturelists = new ArrayList<RtfPictureList>();

    public RtfListTable(RtfDocument doc) {
        super(doc);
    }

    @Override
    public void writeContent(OutputStream out) throws IOException {
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(LIST_TABLE);
        this.document.outputDebugLinebreak(result);
        for (RtfPictureList rtfPictureList : this.picturelists) {
            rtfPictureList.writeDefinition(result);
            this.document.outputDebugLinebreak(result);
        }
        for (RtfList rtfList : this.lists) {
            rtfList.setID(this.document.getRandomInt());
            rtfList.writeDefinition(result);
            this.document.outputDebugLinebreak(result);
        }
        result.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(result);
        result.write(OPEN_GROUP);
        result.write(LIST_OVERRIDE_TABLE);
        this.document.outputDebugLinebreak(result);
        for (RtfList rtfList : this.lists) {
            result.write(OPEN_GROUP);
            result.write(LIST_OVERRIDE);
            result.write(RtfList.LIST_ID);
            result.write(this.intToByteArray(rtfList.getID()));
            result.write(LIST_OVERRIDE_COUNT);
            result.write(this.intToByteArray(0));
            result.write(RtfList.LIST_NUMBER);
            result.write(this.intToByteArray(rtfList.getListNumber()));
            result.write(CLOSE_GROUP);
            this.document.outputDebugLinebreak(result);
        }
        result.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(result);
    }

    public int getListNumber(RtfList list) {
        if (this.lists.contains(list)) {
            return this.lists.indexOf(list);
        }
        this.lists.add(list);
        return this.lists.size();
    }

    public void freeListNumber(RtfList list) {
        int i = this.lists.indexOf(list);
        if (i >= 0) {
            this.lists.remove(i);
        }
    }
}

