/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.ctrlwords;

import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationMgr;

public class RtfCtrlWordHandler
implements Cloneable {
    private static final boolean debug = false;
    protected RtfParser rtfParser = null;
    protected String ctrlWord = "";
    protected int defaultParameterValue = 0;
    protected boolean passDefaultParameterValue = false;
    protected int ctrlWordType = -1;
    protected String specialHandler = "";
    protected float rtfVersionSupported = -1.0f;
    protected RtfCtrlWordData ctrlWordData = null;
    protected String groupPrefix = "";
    protected String ctrlWordPrefix = "\\";
    protected String ctrlWordSuffix = " ";

    private RtfCtrlWordHandler() {
    }

    public RtfCtrlWordHandler(RtfParser rtfParser, String ctrlWord, int defaultParameterValue, boolean passDefaultParameterValue, int ctrlWordType, String prefix, String suffix, String specialHandler) {
        this.rtfParser = rtfParser;
        this.ctrlWord = ctrlWord;
        this.defaultParameterValue = defaultParameterValue;
        this.passDefaultParameterValue = passDefaultParameterValue;
        this.ctrlWordType = ctrlWordType;
        this.ctrlWordPrefix = prefix;
        this.ctrlWordSuffix = suffix;
        this.specialHandler = specialHandler;
        if (this.ctrlWordType == 0 || this.ctrlWordType == 1) {
            if (this.specialHandler == null) {
                this.specialHandler = "RtfDestinationNull";
            }
            String arg1 = "";
            RtfDestinationMgr.addDestination(this.ctrlWord, new Object[]{this.specialHandler, arg1});
        } else if (this.ctrlWordType != 5) {
            if (this.specialHandler == null) {
                this.specialHandler = this.ctrlWord;
            } else if (this.specialHandler.length() > 1 && this.specialHandler.endsWith(".")) {
                this.specialHandler = this.specialHandler + this.ctrlWord;
            }
        }
    }

    public final boolean handleControlword(RtfCtrlWordData ctrlWordDataIn) {
        boolean result = false;
        this.ctrlWordData = ctrlWordDataIn;
        boolean handled = false;
        this.ctrlWordData.prefix = this.ctrlWordPrefix;
        this.ctrlWordData.suffix = this.ctrlWordSuffix;
        this.ctrlWordData.newGroup = this.rtfParser.getState().newGroup;
        this.ctrlWordData.ctrlWordType = this.ctrlWordType;
        this.ctrlWordData.specialHandler = this.specialHandler;
        if (!this.ctrlWordData.hasParam && this.passDefaultParameterValue) {
            this.ctrlWordData.hasParam = true;
            this.ctrlWordData.param = Integer.toString(this.defaultParameterValue);
        }
        if (this.ctrlWordData.ctrlWord.equals("*")) {
            return true;
        }
        if (!this.beforeControlWord()) {
            return true;
        }
        switch (this.ctrlWordType) {
            case 2: 
            case 3: 
            case 4: {
                RtfDestination dest = this.rtfParser.getCurrentDestination();
                if (dest == null) break;
                handled = dest.handleControlWord(this.ctrlWordData);
                break;
            }
            case 5: {
                RtfDestination dest = this.rtfParser.getCurrentDestination();
                if (dest == null) break;
                String data = null;
                if (this.rtfParser.isImport()) {
                    data = this.ctrlWordPrefix + this.ctrlWordData.ctrlWord + this.ctrlWordSuffix;
                }
                if (this.rtfParser.isConvert()) {
                    data = this.specialHandler;
                }
                if (data != null) {
                    for (int idx = 0; idx < data.length(); ++idx) {
                        handled = dest.handleCharacter(data.charAt(idx));
                    }
                    break;
                }
                handled = dest.handleControlWord(this.ctrlWordData);
                break;
            }
            case 0: 
            case 1: {
                int x = 0;
                if ("shppict".equals(this.ctrlWord) || "nonshppict".equals(this.ctrlWord)) {
                    ++x;
                }
                handled = this.rtfParser.setCurrentDestination(this.ctrlWord);
                RtfDestination dest = this.rtfParser.getCurrentDestination();
                if (dest == null) break;
                if (dest.getNewTokeniserState() == 5) {
                    handled = dest.handleControlWord(this.ctrlWordData);
                    break;
                }
                this.rtfParser.setTokeniserState(dest.getNewTokeniserState());
            }
        }
        this.afterControlWord();
        return result;
    }

    protected boolean beforeControlWord() {
        return true;
    }

    protected boolean onControlWord() {
        return false;
    }

    protected boolean afterControlWord() {
        return true;
    }

    private void printDebug(String txt) {
        System.out.println(this.getClass().getName() + " : " + txt);
    }
}

