/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.rtf.direct.RtfDirectContent;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;

public class RtfDestinationShppict
extends RtfDestination {
    private StringBuilder hexChars = new StringBuilder(0);
    private StringBuilder buffer = new StringBuilder();
    private int pictureType = 0;
    private int pmmetafile = 0;
    private Integer bitsPerPixel = 1;
    private Integer planes = 1;
    private Integer widthBytes = null;
    private Long width = null;
    private Long height = null;
    private Long desiredWidth = null;
    private Long desiredHeight = null;
    private Integer scaleX = 100;
    private Integer scaleY = 100;
    private Boolean scaled = null;
    private Boolean inlinePicture = Boolean.FALSE;
    private Boolean wordArt = Boolean.FALSE;
    private Integer cropTop = 0;
    private Integer cropBottom = 0;
    private Integer cropLeft = 0;
    private Integer cropRight = 0;
    private boolean bitmap = false;
    private int bbp = 1;
    public static final int FORMAT_HEXADECIMAL = 0;
    public static final int FORMAT_BINARY = 1;
    private int dataFormat = 0;
    private long binaryLength = 0L;
    private Integer unitsPerInch = null;
    private String tag = "";
    private static final int NORMAL = 0;
    private static final int BLIPUID = 1;
    private int state = 0;
    private static final int PIXEL_TWIPS_FACTOR = 15;
    private ByteArrayOutputStream dataOS = null;

    public RtfDestinationShppict() {
        super(null);
    }

    public RtfDestinationShppict(RtfParser parser) {
        super(parser);
    }

    @Override
    public boolean closeDestination() {
        if (this.rtfParser.isImport() && this.buffer.length() > 0) {
            this.writeBuffer();
        }
        return true;
    }

    @Override
    public boolean handleCloseGroup() {
        this.onCloseGroup();
        if (this.rtfParser.isImport()) {
            if (this.buffer.length() > 0) {
                this.writeBuffer();
            }
            if (this.dataOS != null) {
                this.addImage();
                this.dataOS = null;
            }
            this.writeText("}");
            return true;
        }
        if (this.rtfParser.isConvert() && this.dataOS != null) {
            this.addImage();
            this.dataOS = null;
        }
        return true;
    }

    private boolean addImage() {
        Image img = null;
        try {
            img = Image.getInstance((byte[])this.dataOS.toByteArray());
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (img != null) {
            img.scaleAbsolute(this.desiredWidth.floatValue() / 15.0f, this.desiredHeight.floatValue() / 15.0f);
            img.scaleAbsolute(this.width.floatValue() / 15.0f, this.height.floatValue() / 15.0f);
            img.scalePercent(this.scaleX.floatValue(), this.scaleY.floatValue());
            try {
                if (this.rtfParser.isImport()) {
                    Document doc = this.rtfParser.getDocument();
                    doc.add((Element)img);
                }
                if (this.rtfParser.isConvert()) {
                    this.rtfParser.getDocument().add((Element)img);
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
        this.dataFormat = 0;
        return true;
    }

    @Override
    public boolean handleOpenGroup() {
        this.onOpenGroup();
        if (this.rtfParser.isImport()) {
            // empty if block
        }
        if (this.rtfParser.isConvert()) {
            // empty if block
        }
        return true;
    }

    @Override
    public boolean handleOpeningSubGroup() {
        if (this.rtfParser.isImport() && this.buffer.length() > 0) {
            this.writeBuffer();
        }
        return true;
    }

    @Override
    public boolean handleCharacter(int ch) {
        if (this.rtfParser.isImport() && this.buffer.length() > 254) {
            this.writeBuffer();
        }
        if (this.dataOS == null) {
            this.dataOS = new ByteArrayOutputStream();
        }
        switch (this.dataFormat) {
            case 0: {
                this.hexChars.append((char)ch);
                if (this.hexChars.length() != 2) break;
                try {
                    this.dataOS.write((char)Integer.parseInt(this.hexChars.toString(), 16));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                this.hexChars = new StringBuilder();
                break;
            }
            case 1: {
                this.dataOS.write((char)ch);
                --this.binaryLength;
                if (this.binaryLength != 0L) break;
                this.dataFormat = 0;
            }
        }
        return true;
    }

    @Override
    public boolean handleControlWord(RtfCtrlWordData ctrlWordData) {
        boolean result = false;
        boolean skipCtrlWord = false;
        if (this.rtfParser.isImport()) {
            skipCtrlWord = true;
            if (ctrlWordData.ctrlWord.equals("shppict")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("nonshppict")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("blipuid")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picprop")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("pict")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("emfblip")) {
                result = true;
                this.pictureType = 0;
            } else if (ctrlWordData.ctrlWord.equals("pngblip")) {
                result = true;
                this.pictureType = 2;
            } else if (ctrlWordData.ctrlWord.equals("jepgblip")) {
                result = true;
                this.pictureType = 1;
            } else if (ctrlWordData.ctrlWord.equals("macpict")) {
                result = true;
                this.pictureType = 0;
            } else if (ctrlWordData.ctrlWord.equals("pmmetafile")) {
                result = true;
                this.pictureType = 0;
            } else if (ctrlWordData.ctrlWord.equals("wmetafile")) {
                result = true;
                this.pictureType = 6;
            } else if (ctrlWordData.ctrlWord.equals("dibitmap")) {
                result = true;
                this.pictureType = 0;
            } else if (ctrlWordData.ctrlWord.equals("wbitmap")) {
                result = true;
                this.pictureType = 4;
            } else if (ctrlWordData.ctrlWord.equals("wbmbitspixel")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("wbmplanes")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("wbmwidthbytes")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picw")) {
                this.width = ctrlWordData.toLong();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("pich")) {
                this.height = ctrlWordData.toLong();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picwgoal")) {
                this.desiredWidth = ctrlWordData.toLong();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("pichgoal")) {
                this.desiredHeight = ctrlWordData.toLong();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picscalex")) {
                this.scaleX = ctrlWordData.toInteger();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picscaley")) {
                this.scaleY = ctrlWordData.toInteger();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picscaled")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picprop")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("defshp")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("piccropt")) {
                this.cropTop = ctrlWordData.toInteger();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("piccropb")) {
                this.cropBottom = ctrlWordData.toInteger();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("piccropl")) {
                this.cropLeft = ctrlWordData.toInteger();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("piccropr")) {
                this.cropRight = ctrlWordData.toInteger();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picbmp")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("picbpp")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("bin")) {
                this.dataFormat = 1;
                this.binaryLength = ctrlWordData.longValue();
                this.rtfParser.setTokeniserStateBinary(this.binaryLength);
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("blipupi")) {
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("blipuid")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            } else if (ctrlWordData.ctrlWord.equals("bliptag")) {
                result = true;
            }
        }
        if (this.rtfParser.isConvert()) {
            if (ctrlWordData.ctrlWord.equals("shppict")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("nonshppict")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("blipuid")) {
                result = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("pict")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("emfblip")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("pngblip")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("jepgblip")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("macpict")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("pmmetafile")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("wmetafile")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("dibitmap")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("wbitmap")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("wbmbitspixel")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("wbmplanes")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("wbmwidthbytes")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("picw")) {
                this.width = ctrlWordData.toLong();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("pich")) {
                this.height = ctrlWordData.toLong();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("picwgoal")) {
                this.desiredWidth = ctrlWordData.toLong();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("pichgoal")) {
                this.desiredHeight = ctrlWordData.toLong();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("picscalex")) {
                this.scaleX = ctrlWordData.toInteger();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("picscaley")) {
                this.scaleY = ctrlWordData.toInteger();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("picscaled")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("picprop")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("defshp")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("piccropt")) {
                this.cropTop = ctrlWordData.toInteger();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("piccropb")) {
                this.cropBottom = ctrlWordData.toInteger();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("piccropl")) {
                this.cropLeft = ctrlWordData.toInteger();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("piccropr")) {
                this.cropRight = ctrlWordData.toInteger();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("picbmp")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("picbpp")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("bin")) {
                this.dataFormat = 1;
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("blipupi")) {
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("blipuid")) {
                skipCtrlWord = true;
                this.rtfParser.setTokeniserStateSkipGroup();
                result = true;
            }
            if (ctrlWordData.ctrlWord.equals("bliptag")) {
                result = true;
            }
        }
        if (!skipCtrlWord) {
            switch (this.rtfParser.getConversionType()) {
                case 0: {
                    this.writeBuffer();
                    this.writeText(ctrlWordData.toString());
                    result = true;
                    break;
                }
                case 1: {
                    this.writeBuffer();
                    this.writeText(ctrlWordData.toString());
                    result = true;
                    break;
                }
                case 2: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    @Override
    public void setToDefaults() {
        this.buffer = new StringBuilder();
        this.width = null;
        this.height = null;
        this.desiredWidth = null;
        this.desiredHeight = null;
        this.scaleX = 100;
        this.scaleY = 100;
        this.scaled = null;
        this.inlinePicture = Boolean.FALSE;
        this.wordArt = Boolean.FALSE;
        this.cropTop = 0;
        this.cropBottom = 0;
        this.cropLeft = 0;
        this.cropRight = 0;
        this.bitmap = false;
        this.bbp = 1;
        this.dataFormat = 0;
        this.binaryLength = 0L;
        this.unitsPerInch = null;
        this.tag = "";
    }

    private void writeBuffer() {
        this.writeText(this.buffer.toString());
    }

    private void writeText(String value) {
        if (this.rtfParser.getState().newGroup) {
            this.rtfParser.getRtfDocument().add(new RtfDirectContent("{"));
            this.rtfParser.getState().newGroup = false;
        }
        if (value.length() > 0) {
            this.rtfParser.getRtfDocument().add(new RtfDirectContent(value));
        }
    }
}

