/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.Cell;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Row;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfCell;
import com.lowagie.text.rtf.table.RtfTable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfRow
extends RtfElement {
    private static final byte[] ROW_BEGIN = DocWriter.getISOBytes((String)"\\trowd");
    private static final byte[] ROW_WIDTH_STYLE = DocWriter.getISOBytes((String)"\\trftsWidth3");
    private static final byte[] ROW_WIDTH = DocWriter.getISOBytes((String)"\\trwWidth");
    private static final byte[] ROW_KEEP_TOGETHER = DocWriter.getISOBytes((String)"\\trkeep");
    private static final byte[] ROW_HEADER_ROW = DocWriter.getISOBytes((String)"\\trhdr");
    private static final byte[] ROW_ALIGN_LEFT = DocWriter.getISOBytes((String)"\\trql");
    private static final byte[] ROW_ALIGN_RIGHT = DocWriter.getISOBytes((String)"\\trqr");
    private static final byte[] ROW_ALIGN_CENTER = DocWriter.getISOBytes((String)"\\trqc");
    private static final byte[] ROW_ALIGN_JUSTIFIED = DocWriter.getISOBytes((String)"\\trqj");
    private static final byte[] ROW_GRAPH = DocWriter.getISOBytes((String)"\\trgaph10");
    private static final byte[] ROW_CELL_SPACING_LEFT = DocWriter.getISOBytes((String)"\\trspdl");
    private static final byte[] ROW_CELL_SPACING_TOP = DocWriter.getISOBytes((String)"\\trspdt");
    private static final byte[] ROW_CELL_SPACING_RIGHT = DocWriter.getISOBytes((String)"\\trspdr");
    private static final byte[] ROW_CELL_SPACING_BOTTOM = DocWriter.getISOBytes((String)"\\trspdb");
    private static final byte[] ROW_CELL_SPACING_LEFT_STYLE = DocWriter.getISOBytes((String)"\\trspdfl3");
    private static final byte[] ROW_CELL_SPACING_TOP_STYLE = DocWriter.getISOBytes((String)"\\trspdft3");
    private static final byte[] ROW_CELL_SPACING_RIGHT_STYLE = DocWriter.getISOBytes((String)"\\trspdfr3");
    private static final byte[] ROW_CELL_SPACING_BOTTOM_STYLE = DocWriter.getISOBytes((String)"\\trspdfb3");
    private static final byte[] ROW_CELL_PADDING_LEFT = DocWriter.getISOBytes((String)"\\trpaddl");
    private static final byte[] ROW_CELL_PADDING_RIGHT = DocWriter.getISOBytes((String)"\\trpaddr");
    private static final byte[] ROW_CELL_PADDING_LEFT_STYLE = DocWriter.getISOBytes((String)"\\trpaddfl3");
    private static final byte[] ROW_CELL_PADDING_RIGHT_STYLE = DocWriter.getISOBytes((String)"\\trpaddfr3");
    private static final byte[] ROW_END = DocWriter.getISOBytes((String)"\\row");
    private final RtfTable parentTable;
    private ArrayList<RtfCell> cells = null;
    private int width = 0;
    private final int rowNumber;

    protected RtfRow(RtfDocument doc, RtfTable rtfTable, Row row, int rowNumber) {
        super(doc);
        this.parentTable = rtfTable;
        this.rowNumber = rowNumber;
        this.importRow(row);
    }

    protected RtfRow(RtfDocument doc, RtfTable rtfTable, PdfPRow row, int rowNumber) {
        super(doc);
        this.parentTable = rtfTable;
        this.rowNumber = rowNumber;
        this.importRow(row);
    }

    private void importRow(Row row) {
        this.cells = new ArrayList();
        this.width = this.document.getDocumentHeader().getPageSetting().getPageWidth() - this.document.getDocumentHeader().getPageSetting().getMarginLeft() - this.document.getDocumentHeader().getPageSetting().getMarginRight();
        this.width = (int)((float)this.width * this.parentTable.getTableWidthPercent() / 100.0f);
        int cellRight = 0;
        for (int i = 0; i < row.getColumns(); ++i) {
            int cellWidth = (int)((float)this.width * this.parentTable.getProportionalWidths()[i] / 100.0f);
            Cell cell = (Cell)row.getCell(i);
            RtfCell rtfCell = new RtfCell(this.document, this, cell);
            rtfCell.setCellRight(cellRight += cellWidth);
            rtfCell.setCellWidth(cellWidth);
            this.cells.add(rtfCell);
        }
    }

    private void importRow(PdfPRow row) {
        this.cells = new ArrayList();
        this.width = this.document.getDocumentHeader().getPageSetting().getPageWidth() - this.document.getDocumentHeader().getPageSetting().getMarginLeft() - this.document.getDocumentHeader().getPageSetting().getMarginRight();
        this.width = (int)((float)this.width * this.parentTable.getTableWidthPercent() / 100.0f);
        int cellRight = 0;
        PdfPCell[] cells = row.getCells();
        for (int i = 0; i < cells.length; ++i) {
            int cellWidth = (int)((float)this.width * this.parentTable.getProportionalWidths()[i] / 100.0f);
            PdfPCell cell = cells[i];
            RtfCell rtfCell = new RtfCell(this.document, this, cell);
            rtfCell.setCellRight(cellRight += cellWidth);
            rtfCell.setCellWidth(cellWidth);
            this.cells.add(rtfCell);
        }
    }

    protected void handleCellSpanning() {
        RtfCell deletedCell = new RtfCell(true);
        for (int i = 0; i < this.cells.size(); ++i) {
            int j;
            RtfCell rtfCell = this.cells.get(i);
            if (rtfCell.getColspan() > 1) {
                int cSpan = rtfCell.getColspan();
                for (j = i + 1; j < i + cSpan; ++j) {
                    if (j >= this.cells.size()) continue;
                    RtfCell rtfCellMerge = this.cells.get(j);
                    rtfCell.setCellRight(rtfCell.getCellRight() + rtfCellMerge.getCellWidth());
                    rtfCell.setCellWidth(rtfCell.getCellWidth() + rtfCellMerge.getCellWidth());
                    this.cells.set(j, deletedCell);
                }
            }
            if (rtfCell.getRowspan() <= 1) continue;
            ArrayList<RtfRow> rows = this.parentTable.getRows();
            for (j = 1; j < rtfCell.getRowspan(); ++j) {
                RtfRow mergeRow = (RtfRow)rows.get(this.rowNumber + j);
                if (this.rowNumber + j < rows.size()) {
                    RtfCell rtfCellMerge = mergeRow.getCells().get(i);
                    rtfCellMerge.setCellMergeChild(rtfCell);
                }
                if (rtfCell.getColspan() <= 1) continue;
                int cSpan = rtfCell.getColspan();
                for (int k = i + 1; k < i + cSpan; ++k) {
                    if (k >= mergeRow.getCells().size()) continue;
                    mergeRow.getCells().set(k, deletedCell);
                }
            }
        }
    }

    protected void cleanRow() {
        int i = 0;
        while (i < this.cells.size()) {
            if (this.cells.get(i).isDeleted()) {
                this.cells.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void writeRowDefinition(OutputStream result) throws IOException {
        result.write(ROW_BEGIN);
        this.document.outputDebugLinebreak(result);
        result.write(ROW_WIDTH_STYLE);
        result.write(ROW_WIDTH);
        result.write(this.intToByteArray(this.width));
        if (this.parentTable.getCellsFitToPage()) {
            result.write(ROW_KEEP_TOGETHER);
        }
        if (this.rowNumber <= this.parentTable.getHeaderRows()) {
            result.write(ROW_HEADER_ROW);
        }
        switch (this.parentTable.getAlignment()) {
            case 0: {
                result.write(ROW_ALIGN_LEFT);
                break;
            }
            case 2: {
                result.write(ROW_ALIGN_RIGHT);
                break;
            }
            case 1: {
                result.write(ROW_ALIGN_CENTER);
                break;
            }
            case 3: 
            case 8: {
                result.write(ROW_ALIGN_JUSTIFIED);
            }
        }
        result.write(ROW_GRAPH);
        RtfBorderGroup borders = this.parentTable.getBorders();
        if (borders != null) {
            borders.writeContent(result);
        }
        if (this.parentTable.getCellSpacing() > 0.0f) {
            result.write(ROW_CELL_SPACING_LEFT);
            result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
            result.write(ROW_CELL_SPACING_LEFT_STYLE);
            result.write(ROW_CELL_SPACING_TOP);
            result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
            result.write(ROW_CELL_SPACING_TOP_STYLE);
            result.write(ROW_CELL_SPACING_RIGHT);
            result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
            result.write(ROW_CELL_SPACING_RIGHT_STYLE);
            result.write(ROW_CELL_SPACING_BOTTOM);
            result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
            result.write(ROW_CELL_SPACING_BOTTOM_STYLE);
        }
        result.write(ROW_CELL_PADDING_LEFT);
        result.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
        result.write(ROW_CELL_PADDING_RIGHT);
        result.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
        result.write(ROW_CELL_PADDING_LEFT_STYLE);
        result.write(ROW_CELL_PADDING_RIGHT_STYLE);
        this.document.outputDebugLinebreak(result);
        for (RtfCell rtfCell : this.cells) {
            rtfCell.writeDefinition(result);
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        this.writeRowDefinition(result);
        for (RtfCell rtfCell : this.cells) {
            rtfCell.writeContent(result);
        }
        result.write(DELIMITER);
        if (this.document.getDocumentSettings().isOutputTableRowDefinitionAfter()) {
            this.writeRowDefinition(result);
        }
        result.write(ROW_END);
        this.document.outputDebugLinebreak(result);
    }

    protected RtfTable getParentTable() {
        return this.parentTable;
    }

    protected ArrayList<RtfCell> getCells() {
        return this.cells;
    }
}

