/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Annotation;
import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;

public class RtfAnnotation
extends RtfElement {
    private static final byte[] ANNOTATION_ID = DocWriter.getISOBytes((String)"\\*\\atnid");
    private static final byte[] ANNOTATION_AUTHOR = DocWriter.getISOBytes((String)"\\*\\atnauthor");
    private static final byte[] ANNOTATION = DocWriter.getISOBytes((String)"\\*\\annotation");
    private final String title;
    private final String content;

    public RtfAnnotation(RtfDocument doc, Annotation annotation) {
        super(doc);
        this.title = annotation.title();
        this.content = annotation.content();
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(ANNOTATION_ID);
        result.write(DELIMITER);
        result.write(this.intToByteArray(this.document.getRandomInt()));
        result.write(CLOSE_GROUP);
        result.write(OPEN_GROUP);
        result.write(ANNOTATION_AUTHOR);
        result.write(DELIMITER);
        result.write(DocWriter.getISOBytes((String)this.title));
        result.write(CLOSE_GROUP);
        result.write(OPEN_GROUP);
        result.write(ANNOTATION);
        result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        result.write(DELIMITER);
        result.write(DocWriter.getISOBytes((String)this.content));
        result.write(CLOSE_GROUP);
    }
}

