/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.cachedstore;

import com.mchange.v1.cachedstore.CacheFlushException;
import com.mchange.v1.cachedstore.CachedStoreError;
import com.mchange.v1.cachedstore.CachedStoreException;
import com.mchange.v1.cachedstore.TweakableCachedStore;
import com.mchange.v1.cachedstore.WritableCachedStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class SimpleWritableCachedStore
implements WritableCachedStore {
    private static final Object REMOVE_TOKEN = new Object();
    TweakableCachedStore readOnlyCache;
    WritableCachedStore.Manager manager;
    HashMap writeCache = new HashMap();
    Set failedWrites = null;

    SimpleWritableCachedStore(TweakableCachedStore readOnlyCache, WritableCachedStore.Manager manager) {
        this.readOnlyCache = readOnlyCache;
        this.manager = manager;
    }

    public Object find(Object key) throws CachedStoreException {
        Object out = this.writeCache.get(key);
        if (out == null) {
            out = this.readOnlyCache.find(key);
        }
        return out == REMOVE_TOKEN ? null : out;
    }

    public void write(Object key, Object value) {
        this.writeCache.put(key, value);
    }

    public void remove(Object key) {
        this.write(key, REMOVE_TOKEN);
    }

    public void flushWrites() throws CacheFlushException {
        HashMap writeCacheCopy = (HashMap)this.writeCache.clone();
        for (Object key : writeCacheCopy.keySet()) {
            Object val = writeCacheCopy.get(key);
            try {
                if (val == REMOVE_TOKEN) {
                    this.manager.removeFromStorage(key);
                } else {
                    this.manager.writeToStorage(key, val);
                }
                try {
                    this.readOnlyCache.setCachedValue(key, val);
                    this.writeCache.remove(key);
                    if (this.failedWrites == null) continue;
                    this.failedWrites.remove(key);
                    if (this.failedWrites.size() != 0) continue;
                    this.failedWrites = null;
                }
                catch (CachedStoreException e) {
                    throw new CachedStoreError("SimpleWritableCachedStore: Internal cache is broken!");
                }
            }
            catch (Exception e) {
                if (this.failedWrites == null) {
                    this.failedWrites = new HashSet();
                }
                this.failedWrites.add(key);
            }
        }
        if (this.failedWrites != null) {
            throw new CacheFlushException("Some keys failed to write!");
        }
    }

    public Set getFailedWrites() {
        return this.failedWrites == null ? null : Collections.unmodifiableSet(this.failedWrites);
    }

    public void clearPendingWrites() {
        this.writeCache.clear();
        this.failedWrites = null;
    }

    public void reset() throws CachedStoreException {
        this.writeCache.clear();
        this.readOnlyCache.reset();
        this.failedWrites = null;
    }

    public void sync() throws CachedStoreException {
        this.flushWrites();
        this.reset();
    }
}

