/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.controller;

import com.speedment.common.codegen.constant.DefaultAnnotationUsage;
import com.speedment.common.codegen.constant.DefaultJavadocTag;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.trait.HasFields;
import com.speedment.common.codegen.model.trait.HasImports;
import com.speedment.common.codegen.model.trait.HasMethods;
import com.speedment.common.codegen.model.trait.HasName;
import com.speedment.common.codegen.model.trait.HasSupertype;
import com.speedment.common.codegen.util.Formatting;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class AutoEquals<T extends HasFields<T> & HasMethods<T>>
implements Consumer<T> {
    protected final HasImports<?> importer;
    protected static final String EQUALS = "equals";
    protected static final String HASHCODE = "hashCode";

    public AutoEquals(HasImports<?> importer) {
        this.importer = Objects.requireNonNull(importer);
    }

    @Override
    public void accept(T model) {
        Objects.requireNonNull(model);
        if (!this.hasMethod(model, EQUALS, 1)) {
            this.acceptEquals(model);
        }
        if (!this.hasMethod(model, HASHCODE, 0)) {
            this.acceptHashcode(model);
        }
    }

    protected void acceptEquals(T model) {
        Objects.requireNonNull(model);
        if (this.importer != null) {
            this.importer.add(Import.of(Objects.class));
            this.importer.add(Import.of(Optional.class));
        }
        ((HasMethods)model).add((Method)((Method)((Method)((Method)((Method)((Method)((Method)((Method)((Method)Method.of(EQUALS, Boolean.TYPE).set((Javadoc)((Javadoc)Javadoc.of("Compares this object with the specified one for equality. The other object must be of the same type and not null for the method to return true.").add(DefaultJavadocTag.PARAM.setValue("other").setText("The object to compare with."))).add(DefaultJavadocTag.RETURN.setText("True if the objects are equal.")))).public_()).add(DefaultAnnotationUsage.OVERRIDE)).add(Field.of("other", Object.class))).add("return Optional.ofNullable(other)")).call(m -> {
            Optional<Type> supertype;
            if (HasSupertype.class.isAssignableFrom(model.getClass()) && (supertype = ((HasSupertype)((Object)model)).getSupertype()).isPresent()) {
                m.add(Formatting.tab() + ".filter(o -> super.equals(o))");
            }
        }).add(Formatting.tab() + ".filter(o -> getClass().equals(o.getClass()))")).add(Formatting.tab() + ".map(o -> (" + ((HasName)model).getName() + ") o)")).add(Formatting.tab() + model.getFields().stream().map(this::compare).collect(Collectors.joining(Formatting.nl() + Formatting.tab())))).add(Formatting.tab() + ".isPresent();"));
    }

    protected void acceptHashcode(T model) {
        Objects.requireNonNull(model);
        ((HasMethods)model).add((Method)((Method)((Method)((Method)((Method)((Method)Method.of(HASHCODE, Integer.TYPE).set((Javadoc)Javadoc.of("Generates a hashCode for this object. If any field is changed to another value, the hashCode may be different. Two objects with the same values are guaranteed to have the same hashCode. Two objects with the same hashCode are not guaranteed to have the same hashCode.").add(DefaultJavadocTag.RETURN.setText("The hash code.")))).public_()).add(DefaultAnnotationUsage.OVERRIDE)).add("int hash = 7;")).add(model.getFields().stream().map(this::hash).collect(Collectors.joining(Formatting.nl())))).add("return hash;"));
    }

    protected String compare(Field f) {
        Objects.requireNonNull(f);
        StringBuilder str = new StringBuilder(".filter(o -> ");
        if (this.isPrimitive(f.getType())) {
            str.append("(this.").append(f.getName()).append(" == o.").append(f.getName()).append(")");
        } else {
            str.append("Objects.equals(this.").append(f.getName()).append(", o.").append(f.getName()).append(")");
        }
        return str.append(")").toString();
    }

    protected String hash(Field f) {
        Objects.requireNonNull(f);
        String prefix = "hash = 31 * hash + (";
        String suffix = ".hashCode(this." + f.getName() + "));";
        switch (f.getType().getTypeName()) {
            case "byte": {
                return "hash = 31 * hash + (Byte" + suffix;
            }
            case "short": {
                return "hash = 31 * hash + (Short" + suffix;
            }
            case "int": {
                return "hash = 31 * hash + (Integer" + suffix;
            }
            case "long": {
                return "hash = 31 * hash + (Long" + suffix;
            }
            case "float": {
                return "hash = 31 * hash + (Float" + suffix;
            }
            case "double": {
                return "hash = 31 * hash + (Double" + suffix;
            }
            case "boolean": {
                return "hash = 31 * hash + (Boolean" + suffix;
            }
            case "char": {
                return "hash = 31 * hash + (Character" + suffix;
            }
        }
        return "hash = 31 * hash + (Objects" + suffix;
    }

    protected boolean isPrimitive(Type type) {
        Objects.requireNonNull(type);
        switch (type.getTypeName()) {
            case "byte": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "boolean": 
            case "char": {
                return true;
            }
        }
        return false;
    }

    protected boolean hasMethod(T model, String method, int params) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(method);
        Objects.requireNonNull(params);
        for (Method m : ((HasMethods)model).getMethods()) {
            if (!method.equals(m.getName()) || m.getFields().size() != params) continue;
            return true;
        }
        return false;
    }
}

