/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.java.view;

import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.model.LicenseTerm;
import com.speedment.common.codegen.util.Formatting;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class LicenseTermView
implements Transform<LicenseTerm, String> {
    private static final String LICENSE_DELIMITER = Formatting.nl() + " *";
    private static final String LICENSE_PREFIX = "/*" + LICENSE_DELIMITER;
    private static final String LICENSE_SUFFIX = Formatting.nl() + " */";

    @Override
    public Optional<String> transform(Generator gen, LicenseTerm model) {
        Objects.requireNonNull(gen);
        Objects.requireNonNull(model);
        return Optional.of(Stream.of(model.getText().split(Formatting.nl())).map(s -> s.isEmpty() ? s : " " + s).collect(Collectors.joining(LICENSE_DELIMITER, LICENSE_PREFIX, LICENSE_SUFFIX)));
    }
}

