/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.java.view;

import com.speedment.common.codegen.DependencyManager;
import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.internal.util.NullUtil;
import com.speedment.common.codegen.util.CollectorUtil;
import com.speedment.common.codegen.util.Formatting;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Stream;

public final class TypeView
implements Transform<Type, String> {
    @Override
    public Optional<String> transform(Generator gen, Type model) {
        NullUtil.requireNonNulls(gen, model);
        if (this.shouldUseShortName(gen, model)) {
            return Optional.of(Formatting.shortName(this.renderTypeName(gen, model)));
        }
        return Optional.of(this.renderTypeName(gen, model));
    }

    private String renderTypeName(Generator gen, Type model) {
        StringBuilder name = new StringBuilder();
        name.append(model.getTypeName().replace('$', '.'));
        if (model instanceof ParameterizedType) {
            ParameterizedType hasTypes = (ParameterizedType)model;
            name.append(Stream.of(hasTypes.getActualTypeArguments()).map(gen::on).map(Optional::get).collect(CollectorUtil.joinIfNotEmpty(", ", "<", ">")));
        }
        return name.toString();
    }

    private boolean shouldUseShortName(Generator gen, Type type) {
        NullUtil.requireNonNulls(gen, type);
        DependencyManager mgr = gen.getDependencyMgr();
        String name = Formatting.stripGenerics(type.getTypeName().replace('$', '.'));
        if (mgr.isIgnored(name)) {
            return true;
        }
        if (mgr.isLoaded(name)) {
            return true;
        }
        Optional<String> current = mgr.getCurrentPackage();
        return current.isPresent() && name.startsWith(current.get());
    }
}

