/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.model.ClassOrInterfaceImpl;
import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.Constructor;
import com.speedment.common.codegen.model.Enum;
import com.speedment.common.codegen.model.EnumConstant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class EnumImpl
extends ClassOrInterfaceImpl<Enum>
implements Enum {
    private final List<EnumConstant> constants;
    private final List<Constructor> constructors;

    public EnumImpl(String name) {
        super(name);
        this.constants = new ArrayList<EnumConstant>();
        this.constructors = new ArrayList<Constructor>();
    }

    protected EnumImpl(Enum prototype) {
        super(prototype);
        this.constants = Copier.copy(prototype.getConstants());
        this.constructors = Copier.copy(prototype.getConstructors());
    }

    @Override
    public List<EnumConstant> getConstants() {
        return this.constants;
    }

    @Override
    public List<Constructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public EnumImpl copy() {
        return new EnumImpl(this);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + super.hashCode();
        hash = 13 * hash + Objects.hashCode(this.constants);
        hash = 13 * hash + Objects.hashCode(this.constructors);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        EnumImpl other = (EnumImpl)obj;
        if (!Objects.equals(this.constants, other.constants)) {
            return false;
        }
        return Objects.equals(this.constructors, other.constructors);
    }
}

