/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.io.TosRepeatableFileInputStream;
import com.volcengine.tos.internal.RequestEventListener;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.WrappedTransportRequestBody;
import com.volcengine.tos.internal.model.CRC64Checksum;
import com.volcengine.tos.internal.model.RetryCountNotifier;
import com.volcengine.tos.internal.model.SimpleDataTransferListenInputStream;
import com.volcengine.tos.internal.model.TosCheckedInputStream;
import com.volcengine.tos.internal.util.CRC64Utils;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.dnscache.DnsCacheService;
import com.volcengine.tos.internal.util.dnscache.DnsCacheServiceImpl;
import com.volcengine.tos.internal.util.ratelimit.RateLimitedInputStream;
import com.volcengine.tos.transport.TransportConfig;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.CheckedInputStream;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Source;

public class RequestTransport
implements Transport,
Closeable {
    private static final MediaType DEFAULT_MEDIA_TYPE = null;
    private final OkHttpClient client;
    private int maxRetries;
    private int except100ContinueThreshold;
    private boolean disableEncodingMeta;
    private DnsCacheService dnsCacheService;

    public RequestTransport(TransportConfig config) {
        ParamsChecker.ensureNotNull(config, "TransportConfig");
        int maxConnections = config.getMaxConnections() > 0 ? config.getMaxConnections() : 1024;
        int maxIdleConnectionTimeMills = config.getIdleConnectionTimeMills() > 0 ? config.getIdleConnectionTimeMills() : 60000;
        int readTimeout = config.getReadTimeoutMills() >= 0 ? config.getReadTimeoutMills() : 30000;
        int writeTimeout = config.getWriteTimeoutMills() >= 0 ? config.getWriteTimeoutMills() : 30000;
        int connectTimeout = config.getConnectTimeoutMills() > 0 ? config.getConnectTimeoutMills() : 10000;
        this.maxRetries = config.getMaxRetryCount();
        if (this.maxRetries < 0) {
            this.maxRetries = 0;
        }
        this.except100ContinueThreshold = config.getExcept100ContinueThreshold();
        ConnectionPool connectionPool = new ConnectionPool(maxConnections, (long)maxIdleConnectionTimeMills, TimeUnit.MILLISECONDS);
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(maxConnections);
        dispatcher.setMaxRequestsPerHost(maxConnections);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (!config.isHttp() && !config.isEnableVerifySSL()) {
            builder = TosUtils.ignoreCertificate(builder);
        }
        if (StringUtils.isNotEmpty(config.getProxyHost()) && config.getProxyPort() > 0) {
            this.addProxyConfig(config, builder);
        }
        RequestEventListener.RequestEventListenerFactory eventListener = new RequestEventListener.RequestEventListenerFactory(TosUtils.getLogger()).setHighLatencyLogThreshold(config.getHighLatencyLogThreshold());
        if (config.getDnsCacheTimeMinutes() > 0) {
            this.dnsCacheService = new DnsCacheServiceImpl(config.getDnsCacheTimeMinutes(), 30);
            eventListener.setDnsCacheService(this.dnsCacheService);
            builder.dns(this.createDnsWithCache());
        }
        this.client = builder.dispatcher(dispatcher).connectionPool(connectionPool).retryOnConnectionFailure(false).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).followRedirects(false).followSslRedirects(false).eventListenerFactory((EventListener.Factory)eventListener).build();
    }

    private void addProxyConfig(TransportConfig config, OkHttpClient.Builder builder) {
        InetSocketAddress socketAddress = new InetSocketAddress(config.getProxyHost(), config.getProxyPort());
        builder.proxy(new Proxy(Proxy.Type.HTTP, socketAddress));
        if (StringUtils.isNotEmpty(config.getProxyUserName())) {
            Authenticator proxyAuthenticator = (route, response) -> {
                String credential = Credentials.basic((String)config.getProxyUserName(), (String)config.getProxyPassword());
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            };
            builder.proxyAuthenticator(proxyAuthenticator);
        }
    }

    public RequestTransport setDisableEncodingMeta(boolean disableEncodingMeta) {
        this.disableEncodingMeta = disableEncodingMeta;
        return this;
    }

    private Dns createDnsWithCache() {
        return new Dns(){

            public List<InetAddress> lookup(String host) throws UnknownHostException {
                try {
                    List<InetAddress> ipList = RequestTransport.this.dnsCacheService.getIpList(host);
                    if (ipList == null || ipList.size() == 0) {
                        throw new UnknownHostException("Broken system behaviour for dns lookup of " + host);
                    }
                    if (ipList.size() == 1) {
                        return ipList;
                    }
                    ArrayList<InetAddress> tempIpList = new ArrayList<InetAddress>(ipList.size());
                    for (InetAddress addr : ipList) {
                        tempIpList.add(addr);
                    }
                    Collections.shuffle(tempIpList);
                    return tempIpList;
                }
                catch (RuntimeException e) {
                    UnknownHostException unknownHostException = new UnknownHostException("Broken system behaviour for dns lookup of " + host);
                    unknownHostException.initCause(e);
                    throw unknownHostException;
                }
            }
        };
    }

    @Override
    public void switchConfig(TransportConfig config) {
        this.maxRetries = config.getMaxRetryCount();
        if (this.maxRetries < 0) {
            this.maxRetries = 0;
        }
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    @Override
    public TosResponse roundTrip(TosRequest tosRequest) throws IOException {
        Response response = null;
        long start = System.currentTimeMillis();
        int reqTimes = 1;
        this.wrapTosRequestContent(tosRequest);
        Request lastRequest = null;
        int i = 0;
        while (i < this.maxRetries + 1) {
            try {
                String retryAfter;
                if (tosRequest.getContent() != null && tosRequest.getContent() instanceof RetryCountNotifier) {
                    ((RetryCountNotifier)((Object)tosRequest.getContent())).setRetryCount(i);
                }
                if (lastRequest != null && lastRequest.body() != null && lastRequest.body() instanceof WrappedTransportRequestBody) {
                    ((WrappedTransportRequestBody)lastRequest.body()).reset();
                }
                Request.Builder builder = this.buildRequest(tosRequest);
                if (i != 0) {
                    builder.addHeader("x-sdk-retry-count", "attempt=" + i + "; max=" + this.maxRetries);
                }
                if ((response = this.client.newCall(lastRequest = builder.build()).execute()).code() < 500 && response.code() != 429 && response.code() != 408 && (response.code() != 400 || !"0005-00000044".equals(response.header("X-Tos-Ec"))) || !tosRequest.isRetryableOnServerException() || i == this.maxRetries) break;
                long sleepMs = TosUtils.backoff(i);
                if ((response.code() == 503 || response.code() == 429) && StringUtils.isNotEmpty(retryAfter = response.header("Retry-After"))) {
                    try {
                        sleepMs = Math.max((long)(Integer.valueOf(retryAfter) * 1000), sleepMs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Thread.sleep(sleepMs);
                response.close();
            }
            catch (InterruptedException e) {
                response.close();
                TosUtils.getLogger().debug("tos: request interrupted while sleeping in retry");
                this.printAccessLogFailed(e);
                throw new TosClientException("tos: request interrupted", e);
            }
            catch (IOException e) {
                if (tosRequest.isRetryableOnClientException() && !"mark/reset not supported".equals(e.toString())) {
                    try {
                        if (i == this.maxRetries) {
                            this.printAccessLogFailed(e);
                            throw e;
                        }
                        Thread.sleep(TosUtils.backoff(i));
                        if (response != null) {
                            response.close();
                        }
                    }
                    catch (InterruptedException ie) {
                        if (response != null) {
                            response.close();
                        }
                        TosUtils.getLogger().debug("tos: request interrupted while sleeping in retry");
                        this.printAccessLogFailed(e);
                        throw new TosClientException("tos: request interrupted", e);
                    }
                }
                if (response != null) {
                    response.close();
                }
                this.printAccessLogFailed(e);
                throw e;
            }
            ++i;
            ++reqTimes;
        }
        long end = System.currentTimeMillis();
        ParamsChecker.ensureNotNull(response, "okhttp response");
        this.printAccessLogSucceed(response.code(), response.header("X-Tos-Request-Id"), end - start, reqTimes);
        this.checkCrc(tosRequest, response);
        InputStream inputStream = response.body() == null ? null : response.body().byteStream();
        return new TosResponse().setStatusCode(response.code()).setContentLength(this.getSize(response)).setHeaders(this.getHeaders(response)).setInputStream(inputStream).setSource((Source)(response.body() == null ? null : response.body().source()));
    }

    private void printAccessLogSucceed(int code, String reqId, long cost, int reqTimes) {
        TosUtils.getLogger().info("tos: status code:{}, request id:{}, request cost {} ms, request {} times\n", new Object[]{code, reqId, cost, reqTimes});
    }

    private void printAccessLogFailed(Exception e) {
        TosUtils.getLogger().info("tos: request exception: {}\n", (Object)e.toString());
    }

    private void checkCrc(TosRequest tosRequest, Response response) {
        boolean needCheckCrc;
        boolean bl = needCheckCrc = tosRequest.isEnableCrcCheck() && response.code() < 300 && tosRequest.getContent() != null && tosRequest.getContent() instanceof CheckedInputStream;
        if (!needCheckCrc) {
            return;
        }
        long clientCrcLong = ((CheckedInputStream)tosRequest.getContent()).getChecksum().getValue();
        String clientHashCrc64Ecma = CRC64Utils.longToUnsignedLongString(clientCrcLong);
        String serverHashCrc64Ecma = response.header("x-tos-hash-crc64ecma");
        if (StringUtils.isNotEmpty(serverHashCrc64Ecma) && !StringUtils.equals(clientHashCrc64Ecma, serverHashCrc64Ecma)) {
            throw new TosClientException("tos: crc64 check failed, expected:" + serverHashCrc64Ecma + ", in fact:" + clientHashCrc64Ecma, null);
        }
    }

    private Request.Builder buildRequest(TosRequest request) throws IOException {
        HttpUrl url = request.toURL();
        Request.Builder builder = new Request.Builder().url(url);
        this.addHeader(request, builder);
        switch (request.getMethod() == null ? "" : request.getMethod().toUpperCase()) {
            case "GET": {
                builder.get();
                break;
            }
            case "POST": {
                if (request.getContent() != null && request.getContentLength() <= 0L) {
                    byte[] data = new byte[request.getContent().available()];
                    int exact = request.getContent().read(data);
                    if (exact != -1 && exact != data.length) {
                        throw new IOException("expected " + data.length + " bytes, but got " + exact + " bytes.");
                    }
                    builder.post(RequestBody.create((MediaType)this.getMediaType(request), (byte[])data));
                    break;
                }
                if (request.getContent() != null) {
                    if (this.except100ContinueThreshold > 0 && (request.getContentLength() < 0L || request.getContentLength() > (long)this.except100ContinueThreshold)) {
                        builder.addHeader("Expect", "100-continue");
                    }
                    builder.post((RequestBody)new WrappedTransportRequestBody(this.getMediaType(request), request));
                    break;
                }
                if (request.getData() != null) {
                    if (this.except100ContinueThreshold > 0 && request.getData().length > this.except100ContinueThreshold) {
                        builder.addHeader("Expect", "100-continue");
                    }
                    builder.post(RequestBody.create((MediaType)this.getMediaType(request), (byte[])request.getData()));
                    break;
                }
                builder.post(RequestBody.create((MediaType)this.getMediaType(request), (byte[])new byte[0]));
                break;
            }
            case "PUT": {
                if (request.getContent() != null) {
                    if (this.except100ContinueThreshold > 0 && (request.getContentLength() < 0L || request.getContentLength() > (long)this.except100ContinueThreshold)) {
                        builder.addHeader("Expect", "100-continue");
                    }
                    builder.put((RequestBody)new WrappedTransportRequestBody(this.getMediaType(request), request));
                    break;
                }
                if (request.getData() != null) {
                    if (this.except100ContinueThreshold > 0 && request.getData().length > this.except100ContinueThreshold) {
                        builder.addHeader("Expect", "100-continue");
                    }
                    builder.put(RequestBody.create((MediaType)this.getMediaType(request), (byte[])request.getData()));
                    break;
                }
                builder.put(RequestBody.create((MediaType)this.getMediaType(request), (byte[])new byte[0]));
                break;
            }
            case "HEAD": {
                builder.head();
                break;
            }
            case "DELETE": {
                builder.delete();
                break;
            }
            default: {
                throw new TosClientException("Method is not supported: " + request.getMethod(), null);
            }
        }
        return builder;
    }

    private void addHeader(TosRequest request, Request.Builder builder) {
        if (request == null || builder == null || request.getHeaders() == null) {
            return;
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            builder.header(key, value);
        }
    }

    private void wrapTosRequestContent(TosRequest request) {
        if (request == null || request.getContent() == null) {
            return;
        }
        InputStream originalInputStream = request.getContent();
        InputStream wrappedInputStream = null;
        int readLimit = 524288;
        if (request.getReadLimit() > 0) {
            readLimit = request.getReadLimit();
        }
        wrappedInputStream = originalInputStream.markSupported() ? originalInputStream : (originalInputStream instanceof FileInputStream ? new TosRepeatableFileInputStream((FileInputStream)originalInputStream) : new BufferedInputStream(originalInputStream, readLimit));
        wrappedInputStream.mark(readLimit);
        if (request.getRateLimiter() != null) {
            wrappedInputStream = new RateLimitedInputStream(wrappedInputStream, request.getRateLimiter());
        }
        if (request.getDataTransferListener() != null) {
            wrappedInputStream = new SimpleDataTransferListenInputStream(wrappedInputStream, request.getDataTransferListener(), request.getContentLength());
        }
        if (request.isUseTrailerHeader() || request.isEnableCrcCheck()) {
            CRC64Checksum checksum = new CRC64Checksum(request.getCrc64InitValue());
            wrappedInputStream = new TosCheckedInputStream(wrappedInputStream, checksum);
        }
        request.setContent(wrappedInputStream);
    }

    private MediaType getMediaType(TosRequest request) {
        String type = "";
        if (request.getHeaders() != null && request.getHeaders().containsKey("Content-Type")) {
            type = request.getHeaders().get("Content-Type");
        }
        return StringUtils.isEmpty(type) ? DEFAULT_MEDIA_TYPE : MediaType.parse((String)type);
    }

    private long getSize(Response response) {
        String size = response.header("Content-Length");
        if (StringUtils.isEmpty(size)) {
            return 0L;
        }
        return Long.parseLong(size);
    }

    private Map<String, String> getHeaders(Response response) {
        HashMap<String, String> headers = new HashMap<String, String>(response.headers().size());
        for (String name : response.headers().names()) {
            this.parseHeader(response, headers, name);
        }
        return headers;
    }

    private void parseHeader(Response response, Map<String, String> headers, String name) {
        String key = name;
        String value = response.header(name);
        if (!this.disableEncodingMeta) {
            if (StringUtils.startWithIgnoreCase(key, "X-Tos-Meta-")) {
                key = TosUtils.decodeHeader(key);
                value = TosUtils.decodeHeader(value);
            } else if (StringUtils.equalsIgnoreCase(key, "Content-Disposition")) {
                value = TosUtils.decodeHeader(value);
            }
        }
        headers.put(key.toLowerCase(), value);
    }

    @Override
    public void close() throws IOException {
        if (this.dnsCacheService != null && this.dnsCacheService instanceof Closeable) {
            ((Closeable)((Object)this.dnsCacheService)).close();
        }
        if (this.client != null) {
            this.client.connectionPool().evictAll();
        }
    }
}

