/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.model;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.event.DataTransferStatus;
import com.volcengine.tos.comm.event.DataTransferType;
import com.volcengine.tos.internal.model.DataTransferListenInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentDataTransferListenInputStream
extends DataTransferListenInputStream {
    private final DataTransferListener listener;
    private long totalBytes;
    private long subConsumedBytes;
    private AtomicLong consumedBytes;
    private int unNotifiedBytes;
    private boolean doneEOF;
    private long markedSubConsumedBytes;
    private int markedUnNotifiedBytes;

    public ConcurrentDataTransferListenInputStream(InputStream is, DataTransferListener listener, long total, AtomicLong consumed) {
        super(is);
        if (is == null || listener == null || consumed == null) {
            throw new TosClientException("invalid input", null);
        }
        this.listener = listener;
        this.totalBytes = total;
        this.consumedBytes = consumed;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.bytesRead(1);
        } else {
            this.eof();
        }
        return n;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markedSubConsumedBytes = this.subConsumedBytes;
        this.markedUnNotifiedBytes = this.unNotifiedBytes;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.unNotifiedBytes = this.markedUnNotifiedBytes;
        long old = this.consumedBytes.get();
        this.consumedBytes.compareAndSet(old, old - (this.subConsumedBytes - this.markedSubConsumedBytes));
        this.subConsumedBytes = this.markedSubConsumedBytes;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n != -1) {
            this.bytesRead(n);
        } else {
            this.eof();
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.eof();
        super.close();
    }

    private void onEOF() {
        if (this.unNotifiedBytes > 0) {
            this.calculateBytesRead();
        }
    }

    private void calculateBytesRead() {
        this.subConsumedBytes += (long)this.unNotifiedBytes;
        this.consumedBytes.addAndGet(this.unNotifiedBytes);
        this.onBytesRead(this.unNotifiedBytes);
        this.unNotifiedBytes = 0;
    }

    private void onBytesRead(int bytesRead) {
        DataTransferStatus status = new DataTransferStatus().setType(DataTransferType.DATA_TRANSFER_RW).setTotalBytes(this.totalBytes).setConsumedBytes(this.consumedBytes.get()).setRwOnceBytes(bytesRead).setRetryCount(-1);
        this.listener.dataTransferStatusChange(status);
    }

    private void bytesRead(int bytesRead) {
        this.unNotifiedBytes += bytesRead;
        if (this.unNotifiedBytes >= 524288) {
            this.calculateBytesRead();
        }
    }

    private void eof() {
        if (this.doneEOF) {
            return;
        }
        this.onEOF();
        this.unNotifiedBytes = 0;
        this.doneEOF = true;
    }
}

