/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.comm.Utils;
import com.volcengine.tos.comm.event.DataTransferStatus;
import com.volcengine.tos.comm.event.DataTransferType;
import com.volcengine.tos.comm.event.UploadEventType;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.taskman.AbortTaskHook;
import com.volcengine.tos.internal.taskman.TaskManager;
import com.volcengine.tos.internal.taskman.TaskManagerImpl;
import com.volcengine.tos.internal.taskman.TaskOutput;
import com.volcengine.tos.internal.taskman.UploadFileTask;
import com.volcengine.tos.internal.taskman.UploadFileTaskCanceler;
import com.volcengine.tos.internal.taskman.Util;
import com.volcengine.tos.internal.util.CRC64Utils;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.UploadEvent;
import com.volcengine.tos.model.object.UploadFileInfo;
import com.volcengine.tos.model.object.UploadFileV2Checkpoint;
import com.volcengine.tos.model.object.UploadFileV2Input;
import com.volcengine.tos.model.object.UploadFileV2Output;
import com.volcengine.tos.model.object.UploadPartInfo;
import com.volcengine.tos.model.object.UploadPartV2Output;
import com.volcengine.tos.model.object.UploadedPartV2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class UploadFileTaskHandler {
    private UploadFileV2Input input;
    private TosObjectRequestHandler handler;
    private UploadFileV2Checkpoint checkpoint;
    private boolean enableCrcCheck;
    private TaskManager taskMan;
    private List<UploadedPartV2> uploadedParts;
    private AbortTaskHook abortTaskHook;
    private final AtomicLong consumedBytes;

    public UploadFileTaskHandler(UploadFileV2Input input, TosObjectRequestHandler handler, boolean enableCrcCheck) {
        ParamsChecker.ensureNotNull(input, "UploadFileV2Input");
        ParamsChecker.ensureNotNull(input.getFilePath(), "UploadFilePath");
        ParamsChecker.ensureNotNull(handler, "TosObjectRequestHandler");
        this.input = input;
        this.handler = handler;
        this.enableCrcCheck = enableCrcCheck;
        this.consumedBytes = new AtomicLong(0L);
    }

    public boolean isNullFile() {
        return new File(this.input.getFilePath()).length() == 0L;
    }

    public void initTask() {
        this.validateInput();
        if (this.input.isEnableCheckpoint()) {
            this.validateCheckpointPath();
        }
        UploadFileInfo fileInfo = this.getUploadFileInfo(this.input.getFilePath());
        this.setCheckpoint(fileInfo);
        int partsNum = this.checkpoint.getUploadPartInfos().size();
        this.abortTaskHook = new UploadFileTaskCanceler(this.handler, this.taskMan, this.checkpoint.getBucket(), this.checkpoint.getKey(), this.checkpoint.getUploadID(), this.input.getCheckpointFile(), this.input.isEnableCheckpoint());
        this.taskMan = new TaskManagerImpl(this.input.getTaskNum(), partsNum, null, this.abortTaskHook);
        if (this.input.getCancelHook() != null && this.input.getCancelHook() instanceof UploadFileTaskCanceler) {
            ((UploadFileTaskCanceler)this.input.getCancelHook()).setHandler(this.handler).setTaskMan(this.taskMan).setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setUploadID(this.checkpoint.getUploadID()).setEnableCheckpoint(this.input.isEnableCheckpoint()).setCheckpointFilePath(this.input.getCheckpointFile());
        }
        this.uploadedParts = new ArrayList<UploadedPartV2>(partsNum);
    }

    public void dispatch() {
        for (int i = 0; i < this.checkpoint.getUploadPartInfos().size(); ++i) {
            if (!this.checkpoint.getUploadPartInfos().get(i).isCompleted()) {
                this.taskMan.dispatch(new UploadFileTask(this.checkpoint, i, this.consumedBytes).setEnableCheckpoint(this.input.isEnableCheckpoint()).setCheckpointFile(this.input.getCheckpointFile()).setUploadEventListener(this.input.getUploadEventListener()).setOptions(this.input.getOptions()).setRateLimiter(this.input.getRateLimiter()).setDataTransferListener(this.input.getDataTransferListener()).setHandler(this.handler).setTrafficLimit(this.input.getTrafficLimit()));
                continue;
            }
            UploadPartInfo partInfo = this.checkpoint.getUploadPartInfos().get(i);
            this.uploadedParts.add(new UploadedPartV2().setEtag(partInfo.getEtag()).setPartNumber(partInfo.getPartNumber()));
        }
    }

    public UploadFileV2Output handle() {
        Util.postDataTransferStatus(this.input.getDataTransferListener(), new DataTransferStatus().setType(DataTransferType.DATA_TRANSFER_STARTED).setTotalBytes(this.checkpoint.getFileSize()).setConsumedBytes(this.consumedBytes.get()));
        this.taskMan.handle();
        List<TaskOutput<?>> outputs = this.taskMan.get();
        for (TaskOutput<?> output : outputs) {
            UploadPartV2Output tmp = (UploadPartV2Output)output.getOutput();
            if (tmp == null) continue;
            this.uploadedParts.add(new UploadedPartV2().setPartNumber(tmp.getPartNumber()).setEtag(tmp.getEtag()));
        }
        long total = this.checkpoint.getFileSize();
        long consumed = this.consumedBytes.get();
        DataTransferStatus status = new DataTransferStatus().setTotalBytes(total).setConsumedBytes(consumed);
        if (!this.readyForComplete()) {
            String message = "tos: some upload tasks failed. bucket is " + this.input.getBucket() + ", key is " + this.input.getKey();
            throw new TosClientException(message, null);
        }
        return this.completeUploadFileTask(status);
    }

    private UploadFileV2Output completeUploadFileTask(DataTransferStatus status) {
        CompleteMultipartUploadV2Output comp;
        Util.postDataTransferStatus(this.input.getDataTransferListener(), status.setType(DataTransferType.DATA_TRANSFER_SUCCEED));
        CompleteMultipartUploadV2Input input = new CompleteMultipartUploadV2Input().setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setUploadID(this.checkpoint.getUploadID()).setUploadedParts(this.uploadedParts);
        UploadEvent event = new UploadEvent().setUploadID(this.checkpoint.getUploadID()).setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setCheckpointFile(this.input.getCheckpointFile()).setFilePath(this.input.getFilePath());
        try {
            comp = this.handler.completeMultipartUpload(input);
            if (this.enableCrcCheck) {
                this.combineCrcAndCheck(comp.getHashCrc64ecma());
            }
            Util.postUploadEvent(this.input.getUploadEventListener(), event.setUploadEventType(UploadEventType.UploadEventCompleteMultipartUploadSucceed));
        }
        catch (TosException e) {
            if (e.getStatusCode() == 404 && this.input.isEnableCheckpoint()) {
                Util.deleteCheckpointFile(this.input.getCheckpointFile());
            }
            Util.postUploadEvent(this.input.getUploadEventListener(), event.setTosException(e).setUploadEventType(UploadEventType.UploadEventCompleteMultipartUploadFailed));
            throw e;
        }
        if (this.input.isEnableCheckpoint()) {
            Util.deleteCheckpointFile(this.input.getCheckpointFile());
        }
        return new UploadFileV2Output().setRequestInfo(comp.getRequestInfo()).setBucket(comp.getBucket()).setKey(comp.getKey()).setUploadID(this.checkpoint.getUploadID()).setEtag(comp.getEtag()).setLocation(comp.getLocation()).setHashCrc64ecma(comp.getHashCrc64ecma()).setVersionID(comp.getVersionID()).setSsecAlgorithm(this.checkpoint.getSseAlgorithm()).setSsecKeyMD5(this.checkpoint.getSseKeyMd5()).setEncodingType(this.checkpoint.getEncodingType());
    }

    private boolean readyForComplete() {
        if (this.checkpoint == null || this.checkpoint.getBucket() == null || this.checkpoint.getKey() == null || this.checkpoint.getUploadID() == null || this.checkpoint.getUploadPartInfos() == null || this.uploadedParts == null) {
            return false;
        }
        if (this.uploadedParts.size() != this.checkpoint.getUploadPartInfos().size()) {
            return false;
        }
        for (UploadPartInfo part : this.checkpoint.getUploadPartInfos()) {
            if (!part.isCompleted()) {
                return false;
            }
            if (!this.enableCrcCheck || part.getPartSize() <= 0L || part.getHashCrc64ecma() != 0L) continue;
            return false;
        }
        if (this.input.getDataTransferListener() != null && this.consumedBytes.get() != this.checkpoint.getFileSize()) {
            throw new TosClientException("tos: some upload tasks failed, total: " + this.checkpoint.getFileSize() + ", consumed: " + this.consumedBytes.get(), null);
        }
        return true;
    }

    public void validateInput() {
        if (this.input.getPartSize() == 0L) {
            this.input.setPartSize(0x1400000L);
        }
        Util.validatePartSize(this.input.getPartSize());
        this.input.setTaskNum(Util.determineTaskNum(this.input.getTaskNum()));
        File file = new File(this.input.getFilePath());
        if (!file.exists()) {
            throw new TosClientException("invalid file path, the file does not exist: " + this.input.getFilePath(), null);
        }
        if (file.isDirectory()) {
            throw new TosClientException("do not support directory, please specific your file path", null);
        }
    }

    private void validateCheckpointPath() {
        String checkpointFileSuffix = Util.checkpointPathMd5(this.input.getBucket(), this.input.getKey(), "") + ".upload";
        if (StringUtils.isEmpty(this.input.getCheckpointFile())) {
            this.input.setCheckpointFile(this.input.getFilePath() + "." + checkpointFileSuffix);
        } else {
            File ufcf = new File(this.input.getCheckpointFile());
            if (ufcf.isDirectory()) {
                this.input.setCheckpointFile(this.input.getCheckpointFile() + File.separator + checkpointFileSuffix);
            }
        }
        ParamsChecker.ensureNotNull(this.input.getCheckpointFile(), "checkpointFilePath");
    }

    private void setCheckpoint(UploadFileInfo fileInfo) {
        UploadFileV2Checkpoint checkpoint = null;
        if (this.input.isEnableCheckpoint()) {
            try {
                checkpoint = this.loadCheckpointFromFile(this.input.getCheckpointFile());
            }
            catch (IOException | ClassNotFoundException e) {
                Util.deleteCheckpointFile(this.input.getCheckpointFile());
            }
        }
        boolean valid = false;
        if (checkpoint != null) {
            valid = checkpoint.isValid(fileInfo.getFileSize(), fileInfo.getLastModified(), this.input.getBucket(), this.input.getKey(), this.input.getFilePath());
            if (!valid) {
                Util.deleteCheckpointFile(this.input.getCheckpointFile());
            } else {
                long uploadedBytes = 0L;
                for (UploadPartInfo partInfo : checkpoint.getUploadPartInfos()) {
                    if (!partInfo.isCompleted()) continue;
                    uploadedBytes += partInfo.getPartSize();
                }
                this.consumedBytes.compareAndSet(this.consumedBytes.get(), uploadedBytes);
            }
        }
        if (checkpoint == null || !valid) {
            checkpoint = this.initCheckpoint(fileInfo);
            if (this.input.isEnableCheckpoint()) {
                try {
                    checkpoint.writeToFile(this.input.getCheckpointFile());
                }
                catch (IOException e) {
                    throw new TosClientException("tos: record to checkpoint file failed", e);
                }
            }
        }
        this.checkpoint = checkpoint;
    }

    private UploadFileInfo getUploadFileInfo(String uploadFilePath) {
        File file = new File(uploadFilePath);
        return new UploadFileInfo().setFilePath(uploadFilePath).setFileSize(file.length()).setLastModified(file.lastModified());
    }

    private UploadFileV2Checkpoint initCheckpoint(UploadFileInfo info) throws TosException {
        CreateMultipartUploadOutput output;
        UploadFileV2Checkpoint checkpoint = new UploadFileV2Checkpoint().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setUploadPartInfos(this.getPartsFromFile(info.getFileSize(), this.input.getPartSize())).setFilePath(info.getFilePath()).setFileSize(info.getFileSize()).setLastModified(info.getLastModified());
        UploadEvent createMultipart = new UploadEvent().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setCheckpointFile(this.input.getCheckpointFile()).setFilePath(this.input.getFilePath());
        try {
            output = this.handler.createMultipartUpload(new CreateMultipartUploadInput().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setOptions(this.input.getOptions()).setEncodingType(this.input.getEncodingType()));
            Util.postUploadEvent(this.input.getUploadEventListener(), createMultipart.setUploadID(output.getUploadID()).setUploadEventType(UploadEventType.UploadEventCreateMultipartUploadSucceed));
        }
        catch (TosException e) {
            Util.postUploadEvent(this.input.getUploadEventListener(), createMultipart.setTosException(e).setUploadEventType(UploadEventType.UploadEventCreateMultipartUploadFailed));
            throw e;
        }
        checkpoint.setUploadID(output.getUploadID()).setEncodingType(output.getEncodingType());
        return checkpoint;
    }

    private List<UploadPartInfo> getPartsFromFile(long uploadFileSize, long partSize) {
        long partNum = uploadFileSize / partSize;
        long lastPartSize = uploadFileSize % partSize;
        if (lastPartSize != 0L) {
            ++partNum;
        }
        if (partNum > 10000L) {
            throw new TosClientException("unsupported part number, the maximum is 10000", null);
        }
        ArrayList<UploadPartInfo> partInfoList = new ArrayList<UploadPartInfo>((int)partNum);
        int i = 0;
        while ((long)i < partNum) {
            if ((long)i < partNum - 1L) {
                partInfoList.add(new UploadPartInfo().setPartSize(partSize).setPartNumber(i + 1).setOffset((long)i * partSize));
            } else {
                partInfoList.add(new UploadPartInfo().setPartSize(lastPartSize).setPartNumber(i + 1).setOffset((long)i * partSize));
            }
            ++i;
        }
        if (partNum == 0L) {
            partInfoList.add(new UploadPartInfo().setPartNumber(1).setPartSize(0L).setOffset(0L));
        }
        return partInfoList;
    }

    private UploadFileV2Checkpoint loadCheckpointFromFile(String checkpointFilePath) throws IOException, ClassNotFoundException {
        ParamsChecker.ensureNotNull(checkpointFilePath, "checkpointFilePath is null");
        File f = new File(checkpointFilePath);
        try (FileInputStream checkpointFile = new FileInputStream(f);){
            byte[] data = new byte[(int)f.length()];
            checkpointFile.read(data);
            UploadFileV2Checkpoint uploadFileV2Checkpoint = (UploadFileV2Checkpoint)TosUtils.getJsonMapper().readValue(data, (TypeReference)new TypeReference<UploadFileV2Checkpoint>(){});
            return uploadFileV2Checkpoint;
        }
    }

    private void combineCrcAndCheck(String serverCrc64Value) {
        if (this.checkpoint.getUploadPartInfos() == null || this.checkpoint.getUploadPartInfos().size() == 0 || serverCrc64Value == null) {
            return;
        }
        long crc = this.getCrc();
        if (!Utils.isSameHashCrc64Ecma(crc, serverCrc64Value)) {
            if (this.input.isEnableCheckpoint()) {
                new File(this.input.getCheckpointFile()).delete();
            }
            throw new TosClientException("tos: expect crc64 " + serverCrc64Value + ", actual crc64 " + crc, null);
        }
    }

    private long getCrc() {
        this.checkpoint.getUploadPartInfos().sort(new Comparator<UploadPartInfo>(){

            @Override
            public int compare(UploadPartInfo o1, UploadPartInfo o2) {
                return o1.getPartNumber() - o2.getPartNumber();
            }
        });
        long crc = this.checkpoint.getUploadPartInfos().get(0).getHashCrc64ecma();
        for (int i = 1; i < this.checkpoint.getUploadPartInfos().size(); ++i) {
            long len = this.checkpoint.getUploadPartInfos().get(i).getPartSize();
            crc = CRC64Utils.combine(crc, this.checkpoint.getUploadPartInfos().get(i).getHashCrc64ecma(), len);
        }
        return crc;
    }
}

