/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util;

import com.volcengine.tos.internal.util.IWaitGroup;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WaitGroup
implements IWaitGroup {
    private final AtomicLong al = new AtomicLong(0L);
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();

    @Override
    public void addUninterruptibly() {
        this.addUninterruptibly(1);
    }

    @Override
    public void addUninterruptibly(int n) {
        if (n <= 0) {
            return;
        }
        this.al.addAndGet(n);
    }

    @Override
    public void awaitUninterruptibly() {
        while (this.al.get() != 0L) {
            this.lock.lock();
            this.cond.awaitUninterruptibly();
            this.lock.unlock();
        }
    }

    @Override
    public void add() throws InterruptedException {
        this.addUninterruptibly(1);
    }

    @Override
    public void add(int n) throws InterruptedException {
        this.addUninterruptibly(n);
    }

    @Override
    public void await() throws InterruptedException {
        while (this.al.get() != 0L) {
            this.lock.lock();
            this.cond.await();
            this.lock.unlock();
        }
    }

    @Override
    public void done() {
        this.done(1);
    }

    @Override
    public void done(int n) {
        if (n <= 0) {
            return;
        }
        if (this.al.addAndGet(-n) == 0L) {
            this.lock.lock();
            this.cond.signalAll();
            this.lock.unlock();
        }
    }
}

