/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls.consumer;

import com.volcengine.model.tls.ClientConfig;
import com.volcengine.model.tls.exception.LogException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsumerConfig {
    private static final Log log = LogFactory.getLog(ConsumerConfig.class);
    private static final String DEFAULT_CONSUME_FROM = "begin";
    private static final int DEFAULT_HEARTBEAT_INTERVAL_IN_SECOND = 20;
    private static final int DEFAULT_DATA_FETCH_INTERVAL_IN_MILLISECOND = 200;
    private static final int DEFAULT_FLUSH_CHECKPOINT_INTERVAL_IN_SECOND = 5;
    private static final int DEFAULT_MAX_FETCH_LOG_GROUP_COUNT = 100;
    private static final int DEFAULT_STOP_TIMEOUT = 15;
    private ClientConfig clientConfig;
    private String projectID;
    private String consumerGroupName;
    private List<String> topicIDList;
    private String consumerName;
    private String consumeFrom;
    private int heartbeatIntervalInSecond;
    private int dataFetchIntervalInMillisecond;
    private int flushCheckpointIntervalInSecond;
    private int maxFetchLogGroupCount;
    private boolean orderedConsume;
    private int stopTimeout;

    public ConsumerConfig(String endpoint, String region, String accessKeyId, String accessKeySecret) {
        this(endpoint, region, accessKeyId, accessKeySecret, null);
    }

    public ConsumerConfig(String endpoint, String region, String accessKeyId, String accessKeySecret, String securityToken) {
        this.clientConfig = new ClientConfig(endpoint, region, accessKeyId, accessKeySecret, securityToken);
        this.consumeFrom = DEFAULT_CONSUME_FROM;
        this.heartbeatIntervalInSecond = 20;
        this.dataFetchIntervalInMillisecond = 200;
        this.flushCheckpointIntervalInSecond = 5;
        this.maxFetchLogGroupCount = 100;
        this.orderedConsume = false;
        this.stopTimeout = 15;
    }

    public void validateConsumerConfig() throws LogException {
        this.checkClientConfig(this.clientConfig);
        this.checkEmptyString(this.projectID, "ProjectID");
        this.checkEmptyString(this.consumerGroupName, "ConsumerGroupName");
        this.checkEmptyString(this.consumerName, "ConsumerName");
        if (this.topicIDList == null || this.topicIDList.isEmpty()) {
            throw new LogException("InvalidArgument", "TopicIDList should not be empty.", null);
        }
        for (String topicID : this.topicIDList) {
            this.checkEmptyString(topicID, "TopicID");
        }
        this.checkEmptyString(this.consumeFrom, "ConsumeFrom");
        this.checkIntValueRange(this.heartbeatIntervalInSecond, 1, 300, "HeartbeatIntervalInSecond");
        this.checkIntValueRange(this.dataFetchIntervalInMillisecond, 1, 300000, "DataFetchIntervalInMillisecond");
        this.checkIntValueRange(this.flushCheckpointIntervalInSecond, 1, 300, "FlushCheckpointIntervalInSecond");
        this.checkIntValueRange(this.maxFetchLogGroupCount, 1, 1000, "MaxFetchLogGroupCount");
        this.checkIntValueRange(this.stopTimeout, 1, 300, "StopTimeout");
    }

    public void setClientConfig(ClientConfig clientConfig) throws LogException {
        this.checkClientConfig(clientConfig);
        this.clientConfig = clientConfig;
    }

    private void checkClientConfig(ClientConfig clientConfig) throws LogException {
        if (clientConfig == null || StringUtils.isEmpty((CharSequence)clientConfig.getEndpoint()) || StringUtils.isEmpty((CharSequence)clientConfig.getRegion()) || StringUtils.isEmpty((CharSequence)clientConfig.getAccessKeyId()) || StringUtils.isEmpty((CharSequence)clientConfig.getAccessKeySecret())) {
            throw new LogException("InvalidArgument", String.valueOf(clientConfig), null);
        }
    }

    public void setProjectID(String projectID) throws LogException {
        this.checkEmptyString(projectID, "ProjectID");
        this.projectID = projectID;
    }

    public void setConsumerGroupName(String consumerGroupName) throws LogException {
        this.checkEmptyString(consumerGroupName, "ConsumerGroupName");
        this.consumerGroupName = consumerGroupName;
    }

    public void setTopicIDList(List<String> topicIDList) throws LogException {
        if (topicIDList == null || topicIDList.isEmpty()) {
            throw new LogException("InvalidArgument", "TopicIDList should not be empty.", null);
        }
        for (String topicID : topicIDList) {
            this.checkEmptyString(topicID, "TopicID");
        }
        this.topicIDList = topicIDList;
    }

    public void setConsumerName(String consumerName) throws LogException {
        this.checkEmptyString(consumerName, "ConsumerName");
        this.consumerName = consumerName;
    }

    public void setConsumeFrom(String consumeFrom) throws LogException {
        this.checkEmptyString(consumeFrom, "ConsumeFrom");
        this.consumeFrom = consumeFrom;
    }

    public void setHeartbeatIntervalInSecond(int heartbeatIntervalInSecond) throws LogException {
        this.checkIntValueRange(heartbeatIntervalInSecond, 1, 300, "HeartbeatIntervalInSecond");
        this.heartbeatIntervalInSecond = heartbeatIntervalInSecond;
    }

    public void setDataFetchIntervalInMillisecond(int dataFetchIntervalInMillisecond) throws LogException {
        this.checkIntValueRange(dataFetchIntervalInMillisecond, 1, 300000, "DataFetchIntervalInMillisecond");
        this.dataFetchIntervalInMillisecond = dataFetchIntervalInMillisecond;
    }

    public void setFlushCheckpointIntervalInSecond(int flushCheckpointIntervalInSecond) throws LogException {
        this.checkIntValueRange(flushCheckpointIntervalInSecond, 1, 300, "FlushCheckpointIntervalInSecond");
        this.flushCheckpointIntervalInSecond = flushCheckpointIntervalInSecond;
    }

    public void setMaxFetchLogGroupCount(int maxFetchLogGroupCount) throws LogException {
        this.checkIntValueRange(maxFetchLogGroupCount, 1, 1000, "MaxFetchLogGroupCount");
        this.maxFetchLogGroupCount = maxFetchLogGroupCount;
    }

    public void setOrderedConsume(boolean orderedConsume) {
        this.orderedConsume = orderedConsume;
    }

    public void setStopTimeout(int stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    private void checkEmptyString(String str, String field) throws LogException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new LogException("InvalidArgument", field + " should not be empty.", null);
        }
    }

    private void checkIntValueRange(int value, int lower, int upper, String field) throws LogException {
        if (value < lower || value > upper) {
            throw new LogException("InvalidArgument", field + String.format(" value should between %d and %d", lower, upper), null);
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public List<String> getTopicIDList() {
        return this.topicIDList;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public String getConsumeFrom() {
        return this.consumeFrom;
    }

    public int getHeartbeatIntervalInSecond() {
        return this.heartbeatIntervalInSecond;
    }

    public int getDataFetchIntervalInMillisecond() {
        return this.dataFetchIntervalInMillisecond;
    }

    public int getFlushCheckpointIntervalInSecond() {
        return this.flushCheckpointIntervalInSecond;
    }

    public int getMaxFetchLogGroupCount() {
        return this.maxFetchLogGroupCount;
    }

    public boolean isOrderedConsume() {
        return this.orderedConsume;
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    public String toString() {
        return "ConsumerConfig(clientConfig=" + this.getClientConfig() + ", projectID=" + this.getProjectID() + ", consumerGroupName=" + this.getConsumerGroupName() + ", topicIDList=" + this.getTopicIDList() + ", consumerName=" + this.getConsumerName() + ", consumeFrom=" + this.getConsumeFrom() + ", heartbeatIntervalInSecond=" + this.getHeartbeatIntervalInSecond() + ", dataFetchIntervalInMillisecond=" + this.getDataFetchIntervalInMillisecond() + ", flushCheckpointIntervalInSecond=" + this.getFlushCheckpointIntervalInSecond() + ", maxFetchLogGroupCount=" + this.getMaxFetchLogGroupCount() + ", orderedConsume=" + this.isOrderedConsume() + ", stopTimeout=" + this.getStopTimeout() + ")";
    }
}

