/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls.response;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.model.tls.exception.LogException;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.http.Header;

public class CommonResponse {
    String requestId;
    Header[] headers;

    public CommonResponse(Header[] headers) {
        this.headers = headers;
        this.requestId = this.getFirstHeader("X-Tls-Requestid");
    }

    public String getFirstHeader(String key) {
        if (key != null && this.headers != null) {
            for (Header header : this.headers) {
                if (!header.getName().equalsIgnoreCase(key)) continue;
                return header.getValue();
            }
        }
        return null;
    }

    public CommonResponse deSerialize(byte[] data, Class clazz) throws LogException {
        return (CommonResponse)JSONObject.parseObject((byte[])data, (Type)clazz, (Feature[])new Feature[0]);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonResponse)) {
            return false;
        }
        CommonResponse other = (CommonResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        return Arrays.deepEquals(this.getHeaders(), other.getHeaders());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHeaders());
        return result;
    }

    public String toString() {
        return "CommonResponse(super=" + super.toString() + ", requestId=" + this.getRequestId() + ", headers=" + Arrays.deepToString(this.getHeaders()) + ")";
    }

    public CommonResponse(String requestId, Header[] headers) {
        this.requestId = requestId;
        this.headers = headers;
    }

    public CommonResponse() {
    }
}

