/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.kms.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.request.kms.CancelKeyDeletionRequest;
import com.volcengine.model.request.kms.CreateKeyRequest;
import com.volcengine.model.request.kms.CreateKeyringRequest;
import com.volcengine.model.request.kms.DecryptRequest;
import com.volcengine.model.request.kms.DescribeKeyringsRequest;
import com.volcengine.model.request.kms.DescribeKeysRequest;
import com.volcengine.model.request.kms.DisableKeyRequest;
import com.volcengine.model.request.kms.EnableKeyRequest;
import com.volcengine.model.request.kms.EncryptRequest;
import com.volcengine.model.request.kms.GenerateDataKeyRequest;
import com.volcengine.model.request.kms.QueryKeyringRequest;
import com.volcengine.model.request.kms.ScheduleKeyDeletionRequest;
import com.volcengine.model.request.kms.UpdateKeyRequest;
import com.volcengine.model.request.kms.UpdateKeyringRequest;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.kms.CancelKeyDeletionResponse;
import com.volcengine.model.response.kms.CreateKeyResponse;
import com.volcengine.model.response.kms.CreateKeyringResponse;
import com.volcengine.model.response.kms.DecryptResponse;
import com.volcengine.model.response.kms.DescribeKeyringsResponse;
import com.volcengine.model.response.kms.DescribeKeysResponse;
import com.volcengine.model.response.kms.DisableKeyResponse;
import com.volcengine.model.response.kms.EnableKeyResponse;
import com.volcengine.model.response.kms.EncryptResponse;
import com.volcengine.model.response.kms.GenerateDataKeyResponse;
import com.volcengine.model.response.kms.QueryKeyringResponse;
import com.volcengine.model.response.kms.ScheduleKeyDeletionResponse;
import com.volcengine.model.response.kms.UpdateKeyResponse;
import com.volcengine.model.response.kms.UpdateKeyringResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.kms.IKmsService;
import com.volcengine.service.kms.KmsConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class KmsServiceImpl
extends BaseServiceImpl
implements IKmsService {
    private KmsServiceImpl() {
        super(KmsConfig.serviceInfo, KmsConfig.apiInfoList);
    }

    public static IKmsService getInstance() {
        return new KmsServiceImpl();
    }

    private RawResponse commonHandlerQuery(String api, List<NameValuePair> params) throws Exception {
        RawResponse response = this.query(api, params);
        return response;
    }

    private RawResponse commonHandlerJson(String api, List<NameValuePair> params, Map<String, Object> reqBody) throws Exception {
        String body = JSON.toJSONString(reqBody);
        RawResponse response = this.json(api, params, body);
        return response;
    }

    @Override
    public CreateKeyringResponse createKeyring(CreateKeyringRequest req) throws Exception {
        RawResponse response;
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        if (req.getKeyringType() != null && req.getKeyringType().length() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("KeyringType", req.getKeyringType()));
        }
        if (req.getDescription() != null) {
            query.add((NameValuePair)new BasicNameValuePair("Description", req.getDescription()));
        }
        if ((response = this.commonHandlerQuery("CreateKeyring", query)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CreateKeyringResponse)JSON.parseObject((byte[])response.getData(), CreateKeyringResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DescribeKeyringsResponse describeKeyrings(DescribeKeyringsRequest req) throws Exception {
        RawResponse response;
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        if (req.getCurrentPage() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("CurrentPage", String.valueOf(req.getCurrentPage())));
        }
        if (req.getPageSize() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(req.getPageSize())));
        }
        if ((response = this.commonHandlerQuery("DescribeKeyrings", query)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DescribeKeyringsResponse)JSON.parseObject((byte[])response.getData(), DescribeKeyringsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public UpdateKeyringResponse updateKeyring(UpdateKeyringRequest req) throws Exception {
        RawResponse response;
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        if (req.getNewKeyringName() != null && req.getNewKeyringName().length() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("NewKeyringName", req.getNewKeyringName()));
        }
        if (req.getDescription() != null) {
            query.add((NameValuePair)new BasicNameValuePair("Description", req.getDescription()));
        }
        if ((response = this.commonHandlerQuery("UpdateKeyring", query)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (UpdateKeyringResponse)JSON.parseObject((byte[])response.getData(), UpdateKeyringResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public QueryKeyringResponse queryKeyring(QueryKeyringRequest req) throws Exception {
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        RawResponse response = this.commonHandlerQuery("QueryKeyring", query);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (QueryKeyringResponse)JSON.parseObject((byte[])response.getData(), QueryKeyringResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CreateKeyResponse createKey(CreateKeyRequest req) throws Exception {
        RawResponse response;
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        query.add((NameValuePair)new BasicNameValuePair("KeyName", req.getKeyName()));
        if (req.getKeySpec() != null && req.getKeySpec().length() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("KeySpec", req.getKeySpec()));
        }
        if (req.getKeyUsage() != null && req.getKeyUsage().length() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("KeyUsage", req.getKeySpec()));
        }
        if (req.getProtectionLevel() != null && req.getProtectionLevel().length() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("ProtectionLevel", req.getKeySpec()));
        }
        if (req.getDescription() != null) {
            query.add((NameValuePair)new BasicNameValuePair("Description", req.getDescription()));
        }
        if ((response = this.commonHandlerQuery("CreateKey", query)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CreateKeyResponse)JSON.parseObject((byte[])response.getData(), CreateKeyResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DescribeKeysResponse describeKeys(DescribeKeysRequest req) throws Exception {
        RawResponse response;
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        if (req.getCurrentPage() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("CurrentPage", String.valueOf(req.getCurrentPage())));
        }
        if (req.getPageSize() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(req.getPageSize())));
        }
        if ((response = this.commonHandlerQuery("DescribeKeys", query)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DescribeKeysResponse)JSON.parseObject((byte[])response.getData(), DescribeKeysResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public UpdateKeyResponse updateKey(UpdateKeyRequest req) throws Exception {
        RawResponse response;
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        query.add((NameValuePair)new BasicNameValuePair("KeyName", req.getKeyName()));
        if (req.getNewKeyName() != null && req.getNewKeyName().length() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("NewKeyName", req.getNewKeyName()));
        }
        if (req.getDescription() != null) {
            query.add((NameValuePair)new BasicNameValuePair("Description", req.getDescription()));
        }
        if ((response = this.commonHandlerQuery("UpdateKey", query)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (UpdateKeyResponse)JSON.parseObject((byte[])response.getData(), UpdateKeyResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest req) throws Exception {
        RawResponse response;
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        query.add((NameValuePair)new BasicNameValuePair("KeyName", req.getKeyName()));
        if (req.getNumberOfBytes() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("NumberOfBytes", String.valueOf(req.getNumberOfBytes())));
        }
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        if (req.getEncryptionContext() != null) {
            reqBody.put("EncryptionContext", req.getEncryptionContext());
        }
        if ((response = this.commonHandlerJson("GenerateDataKey", query, reqBody)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GenerateDataKeyResponse)JSON.parseObject((byte[])response.getData(), GenerateDataKeyResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public EncryptResponse encrypt(EncryptRequest req) throws Exception {
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        query.add((NameValuePair)new BasicNameValuePair("KeyName", req.getKeyName()));
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        if (req.getEncryptionContext() != null) {
            reqBody.put("EncryptionContext", req.getEncryptionContext());
        }
        reqBody.put("Plaintext", req.getPlaintext());
        RawResponse response = this.commonHandlerJson("Encrypt", query, reqBody);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (EncryptResponse)JSON.parseObject((byte[])response.getData(), EncryptResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DecryptResponse decrypt(DecryptRequest req) throws Exception {
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        if (req.getEncryptionContext() != null) {
            reqBody.put("EncryptionContext", req.getEncryptionContext());
        }
        reqBody.put("CiphertextBlob", req.getCiphertextBlob());
        RawResponse response = this.commonHandlerJson("Decrypt", query, reqBody);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DecryptResponse)JSON.parseObject((byte[])response.getData(), DecryptResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public EnableKeyResponse enableKey(EnableKeyRequest req) throws Exception {
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        query.add((NameValuePair)new BasicNameValuePair("KeyName", req.getKeyName()));
        RawResponse response = this.commonHandlerQuery("EnableKey", query);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (EnableKeyResponse)JSON.parseObject((byte[])response.getData(), EnableKeyResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DisableKeyResponse disable(DisableKeyRequest req) throws Exception {
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        query.add((NameValuePair)new BasicNameValuePair("KeyName", req.getKeyName()));
        RawResponse response = this.commonHandlerQuery("DisableKey", query);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DisableKeyResponse)JSON.parseObject((byte[])response.getData(), DisableKeyResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ScheduleKeyDeletionResponse scheduleKeyDeletion(ScheduleKeyDeletionRequest req) throws Exception {
        RawResponse response;
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        query.add((NameValuePair)new BasicNameValuePair("KeyName", req.getKeyName()));
        if (req.getPendingWindowInDays() != 0) {
            query.add((NameValuePair)new BasicNameValuePair("PendingWindowInDays", String.valueOf(req.getKeyName())));
        }
        if ((response = this.commonHandlerQuery("ScheduleKeyDeletion", query)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ScheduleKeyDeletionResponse)JSON.parseObject((byte[])response.getData(), ScheduleKeyDeletionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CancelKeyDeletionResponse cancelKeyDeletion(CancelKeyDeletionRequest req) throws Exception {
        ArrayList<NameValuePair> query = new ArrayList<NameValuePair>();
        query.add((NameValuePair)new BasicNameValuePair("KeyringName", req.getKeyringName()));
        query.add((NameValuePair)new BasicNameValuePair("KeyName", req.getKeyName()));
        RawResponse response = this.commonHandlerQuery("CancelKeyDeletion", query);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CancelKeyDeletionResponse)JSON.parseObject((byte[])response.getData(), CancelKeyDeletionResponse.class, (Feature[])new Feature[0]);
    }
}

