/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze;

import com.weibo.breeze.BreezeContext;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.Utf8;
import java.nio.ByteBuffer;

public class BreezeBuffer {
    private static final int MAX_VARINT_LENGTH = 10;
    private ByteBuffer buf;
    private BreezeContext context;

    public BreezeBuffer(int initSize) {
        this.buf = ByteBuffer.allocate(initSize);
    }

    public BreezeBuffer(ByteBuffer buf) {
        this.buf = buf;
    }

    public BreezeBuffer(byte[] bytes) {
        this.buf = ByteBuffer.wrap(bytes);
    }

    public static int encodeZigzag32(int value) {
        return value << 1 ^ value >> 31;
    }

    public static long encodeZigzag64(long value) {
        return value << 1 ^ value >> 63;
    }

    public static int decodeZigzag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigzag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public void put(byte b) {
        this.ensureBufferEnough(1);
        this.buf.put(b);
    }

    public void put(int index, byte b) {
        this.buf.put(index, b);
    }

    public void put(byte[] b) {
        this.ensureBufferEnough(b.length);
        this.buf.put(b);
    }

    public void put(byte[] b, int offset, int length) {
        this.ensureBufferEnough(b.length);
        this.buf.put(b, offset, length);
    }

    public void putShort(short value) {
        this.ensureBufferEnough(2);
        this.buf.putShort(value);
    }

    public void putShort(int index, short value) {
        this.buf.putShort(index, value);
    }

    public void putInt(int value) {
        this.ensureBufferEnough(4);
        this.buf.putInt(value);
    }

    public void putInt(int index, int value) {
        this.buf.putInt(index, value);
    }

    public void putLong(long value) {
        this.ensureBufferEnough(8);
        this.buf.putLong(value);
    }

    public void putLong(int index, long value) {
        this.buf.putLong(index, value);
    }

    public void putFloat(float value) {
        this.ensureBufferEnough(4);
        this.buf.putFloat(value);
    }

    public void putFloat(int index, float value) {
        this.buf.putFloat(index, value);
    }

    public void putDouble(double value) {
        this.ensureBufferEnough(8);
        this.buf.putDouble(value);
    }

    public void putDouble(int index, double value) {
        this.buf.putDouble(index, value);
    }

    public int putZigzag32(int value) {
        return this.putVarint(BreezeBuffer.encodeZigzag32(value));
    }

    public int putZigzag64(long value) {
        return this.putVarint(BreezeBuffer.encodeZigzag64(value));
    }

    public int putVarint(long value) {
        this.ensureBufferEnough(10);
        int count = 0;
        while (true) {
            ++count;
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.buf.put((byte)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        this.buf.put((byte)value);
        return count;
    }

    public int getUTF8Length(String string) {
        return Utf8.encodedLength(string);
    }

    public void putUTF8(String string, int length, boolean putLength) {
        if (putLength) {
            this.putVarint(length);
        }
        if (length > 0) {
            this.ensureBufferEnough(length);
            Utf8.encodeUtf8(string, this.buf);
        }
    }

    public String getUTF8(int size) throws BreezeException {
        if (size < 0) {
            size = (int)this.getVarint();
        }
        if (size == 0) {
            return "";
        }
        if (size > this.buf.remaining()) {
            throw new BreezeException("Breeze deserialize utf8 string fail! buffer not enough!need size:" + size);
        }
        String result = Utf8.decodeUtf8(this.buf, this.buf.position(), size);
        this.buf.position(this.buf.position() + size);
        return result;
    }

    public byte get() {
        return this.buf.get();
    }

    public byte get(int index) {
        return this.buf.get(index);
    }

    public void get(byte[] dst) {
        this.buf.get(dst);
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.buf.remaining()];
        this.buf.get(result);
        return result;
    }

    public short getShort() {
        return this.buf.getShort();
    }

    public short getShort(int index) {
        return this.buf.getShort(index);
    }

    public int getInt() {
        return this.buf.getInt();
    }

    public int getInt(int index) {
        return this.buf.getInt(index);
    }

    public long getLong() {
        return this.buf.getLong();
    }

    public long getLong(int index) {
        return this.buf.getLong(index);
    }

    public float getFloat() {
        return this.buf.getFloat();
    }

    public float getFloat(int index) {
        return this.buf.getFloat(index);
    }

    public double getDouble() {
        return this.buf.getDouble();
    }

    public double getDouble(int index) {
        return this.buf.getDouble(index);
    }

    public int getZigzag32() {
        return BreezeBuffer.decodeZigzag32((int)this.getVarint());
    }

    public long getZigzag64() {
        return BreezeBuffer.decodeZigzag64(this.getVarint());
    }

    public long getVarint() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.buf.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Integer overflow");
    }

    public void flip() {
        this.buf.flip();
    }

    public int position() {
        return this.buf.position();
    }

    public void position(int newPosition) {
        this.ensureBufferEnough(newPosition - this.buf.position());
        this.buf.position(newPosition);
    }

    public int limit() {
        return this.buf.limit();
    }

    public void limit(int newLimit) {
        this.buf.limit(newLimit);
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public void clear() {
        this.buf.clear();
    }

    private ByteBuffer grow(int size) {
        ByteBuffer newbuf = ByteBuffer.allocate(size);
        newbuf.put(this.buf.array());
        newbuf.position(this.buf.position());
        return newbuf;
    }

    private void ensureBufferEnough(int need) {
        int expandSize = this.buf.position() + need;
        if (this.buf.capacity() < expandSize) {
            int size;
            for (size = this.buf.capacity() * 2; size < expandSize; size *= 2) {
            }
            this.buf = this.grow(size);
        }
    }

    public BreezeContext getContext() {
        if (this.context == null) {
            this.context = new BreezeContext();
        }
        return this.context;
    }
}

