/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import io.agroal.api.transaction.TransactionAware;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.XAResourceWrapper;

public class LocalXAResource
implements XAResource,
XAResourceWrapper {
    private final TransactionAware connection;
    private static final String PRODUCT_NAME = LocalXAResource.class.getPackage().getImplementationTitle();
    private static final String PRODUCT_VERSION = LocalXAResource.class.getPackage().getImplementationVersion();
    private final String jndiName;
    private Xid currentXid;

    public LocalXAResource(TransactionAware connection) {
        this(connection, "");
    }

    public LocalXAResource(TransactionAware connection, String jndiName) {
        this.connection = connection;
        this.jndiName = jndiName;
    }

    protected TransactionAware getTransactionAware() {
        return this.connection;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.currentXid == null) {
            if (flags != 0) {
                throw new XAException("Starting resource with wrong flags");
            }
            try {
                this.connection.transactionStart();
            }
            catch (Exception t) {
                throw new XAException("Error trying to start local transaction: " + t.getMessage());
            }
            this.currentXid = xid;
        } else if (flags != 0x200000 && flags != 0x8000000) {
            throw new XAException(-8);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            throw new XAException("Invalid xid to transactionCommit");
        }
        this.currentXid = null;
        try {
            this.connection.transactionCommit();
            this.connection.transactionEnd();
        }
        catch (Exception t) {
            throw new XAException("Error trying to transactionCommit local transaction: " + t.getMessage());
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            throw new XAException("Invalid xid to transactionRollback");
        }
        this.currentXid = null;
        try {
            this.connection.transactionRollback();
            this.connection.transactionEnd();
        }
        catch (Exception t) {
            throw new XAException("Error trying to transactionRollback local transaction: " + t.getMessage());
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            throw new XAException("Invalid xid to transactionEnd");
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw new XAException("Forget not supported in local XA resource");
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this == xaResource;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        throw new XAException("No recover in local XA resource");
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    public XAResource getResource() {
        return this;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

