/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.ws.StringWebSocketClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import org.openqa.selenium.remote.RemoteWebDriver;

public interface ListensToLogcatMessages
extends ExecutesMethod {
    public StringWebSocketClient getLogcatClient();

    default public void startLogcatBroadcast() {
        this.startLogcatBroadcast("127.0.0.1", 4723);
    }

    default public void startLogcatBroadcast(String host) {
        this.startLogcatBroadcast(host, 4723);
    }

    default public void startLogcatBroadcast(String host, int port) {
        URI endpointUri;
        CommandExecutionHelper.executeScript(this, "mobile: startLogsBroadcast");
        try {
            endpointUri = new URI(String.format("ws://%s:%s/ws/session/%s/appium/device/logcat", host, port, ((RemoteWebDriver)this).getSessionId()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.getLogcatClient().connect(endpointUri);
    }

    default public void addLogcatMessagesListener(Consumer<String> handler) {
        this.getLogcatClient().addMessageHandler(handler);
    }

    default public void addLogcatErrorsListener(Consumer<Throwable> handler) {
        this.getLogcatClient().addErrorHandler(handler);
    }

    default public void addLogcatConnectionListener(Runnable handler) {
        this.getLogcatClient().addConnectionHandler(handler);
    }

    default public void addLogcatDisconnectionListener(Runnable handler) {
        this.getLogcatClient().addDisconnectionHandler(handler);
    }

    default public void removeAllLogcatListeners() {
        this.getLogcatClient().removeAllHandlers();
    }

    default public void stopLogcatBroadcast() {
        this.removeAllLogcatListeners();
        CommandExecutionHelper.executeScript(this, "mobile: stopLogsBroadcast");
    }
}

