/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.ThrowableUtil;
import io.appium.java_client.pagefactory.bys.ContentMappedBy;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import io.appium.java_client.pagefactory.utils.WebDriverUnpackUtility;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

class AppiumElementLocator
implements CacheableLocator {
    private static final String EXCEPTION_MESSAGE_IF_ELEMENT_NOT_FOUND = "Can't locate an element by this strategy: %s";
    private final boolean shouldCache;
    private final By by;
    private final Duration duration;
    private final WeakReference<SearchContext> searchContextReference;
    private final SearchContext searchContext;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;

    AppiumElementLocator(WeakReference<SearchContext> searchContextReference, By by, boolean shouldCache, Duration duration) {
        this.searchContextReference = searchContextReference;
        this.searchContext = null;
        this.shouldCache = shouldCache;
        this.duration = duration;
        this.by = by;
    }

    public AppiumElementLocator(SearchContext searchContext, By by, boolean shouldCache, Duration duration) {
        this.searchContextReference = null;
        this.searchContext = searchContext;
        this.shouldCache = shouldCache;
        this.duration = duration;
        this.by = by;
    }

    private Optional<SearchContext> getSearchContext() {
        return this.searchContext == null ? Optional.ofNullable(this.searchContextReference).map(Reference::get) : Optional.of(this.searchContext);
    }

    private static By getBy(By currentBy, SearchContext currentContent) {
        if (!ContentMappedBy.class.isAssignableFrom(currentBy.getClass())) {
            return currentBy;
        }
        return ((ContentMappedBy)currentBy).useContent(WebDriverUnpackUtility.getCurrentContentType(currentContent));
    }

    private <T> T waitFor(Supplier<T> supplier) {
        WaitingFunction function = new WaitingFunction();
        try {
            FluentWait wait = new FluentWait(supplier).ignoring(NoSuchElementException.class);
            wait.withTimeout(this.duration);
            return (T)wait.until(function);
        }
        catch (TimeoutException e) {
            if (function.foundStaleElementReferenceException != null) {
                throw (StaleElementReferenceException)function.foundStaleElementReferenceException;
            }
            throw e;
        }
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        SearchContext searchContext = this.getSearchContext().orElseThrow(() -> new IllegalStateException(String.format("The element %s is not locatable anymore because its context has been garbage collected", this.by)));
        By bySearching = AppiumElementLocator.getBy(this.by, searchContext);
        try {
            WebElement result = this.waitFor(() -> searchContext.findElement(bySearching));
            if (this.shouldCache) {
                this.cachedElement = result;
            }
            return result;
        }
        catch (StaleElementReferenceException | TimeoutException e) {
            throw new NoSuchElementException(String.format(EXCEPTION_MESSAGE_IF_ELEMENT_NOT_FOUND, bySearching.toString()), e);
        }
    }

    public List<WebElement> findElements() {
        ArrayList<WebElement> result;
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        SearchContext searchContext = this.getSearchContext().orElseThrow(() -> new IllegalStateException(String.format("Elements %s are not locatable anymore because their context has been garbage collected", this.by)));
        try {
            result = this.waitFor(() -> {
                List list = searchContext.findElements(AppiumElementLocator.getBy(this.by, searchContext));
                return list.isEmpty() ? null : list;
            });
        }
        catch (StaleElementReferenceException | TimeoutException e) {
            result = new ArrayList();
        }
        if (this.shouldCache) {
            this.cachedElementList = result;
        }
        return result;
    }

    @Override
    public boolean isLookUpCached() {
        return this.shouldCache;
    }

    public String toString() {
        return String.format("Located by %s", this.by);
    }

    private static class WaitingFunction<T>
    implements Function<Supplier<T>, T> {
        private Throwable foundStaleElementReferenceException;

        private WaitingFunction() {
        }

        @Override
        public T apply(Supplier<T> supplier) {
            this.foundStaleElementReferenceException = null;
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                boolean isRootCauseStaleElementReferenceException = false;
                boolean isRootCauseInvalidSelector = ThrowableUtil.isInvalidSelectorRootCause(e);
                if (!isRootCauseInvalidSelector) {
                    isRootCauseStaleElementReferenceException = ThrowableUtil.isStaleElementReferenceException(e);
                }
                if (isRootCauseStaleElementReferenceException) {
                    this.foundStaleElementReferenceException = ThrowableUtil.extractReadableException(e);
                }
                if (isRootCauseInvalidSelector || isRootCauseStaleElementReferenceException) {
                    return null;
                }
                Throwable excToThrow = ThrowableUtil.extractReadableException(e);
                if (excToThrow instanceof WebDriverException) {
                    throw (WebDriverException)excToThrow;
                }
                throw new WebDriverException(excToThrow);
            }
        }
    }
}

