/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.utils;

import io.appium.java_client.proxy.Helpers;
import io.appium.java_client.proxy.MethodCallListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class ProxyFactory {
    private static final Set<String> NON_PROXYABLE_METHODS = ProxyFactory.setWith(ProxyFactory.setWithout(Helpers.OBJECT_METHOD_NAMES, "toString"), "iterator");

    @SafeVarargs
    private static <T> Set<T> setWithout(Set<T> source, T ... items) {
        HashSet<T> result = new HashSet<T>(source);
        Arrays.asList(items).forEach(result::remove);
        return Collections.unmodifiableSet(result);
    }

    @SafeVarargs
    private static <T> Set<T> setWith(Set<T> source, T ... items) {
        HashSet<T> result = new HashSet<T>(source);
        result.addAll(List.of(items));
        return Collections.unmodifiableSet(result);
    }

    private ProxyFactory() {
    }

    public static <T> T getEnhancedProxy(Class<T> requiredClazz, MethodCallListener listener) {
        return ProxyFactory.getEnhancedProxy(requiredClazz, new Class[0], new Object[0], listener);
    }

    public static <T> T getEnhancedProxy(Class<T> cls, Class<?>[] params, Object[] values, MethodCallListener listener) {
        ElementMatcher.Junction extraMatcher = ElementMatchers.not((ElementMatcher)ElementMatchers.namedOneOf((String[])NON_PROXYABLE_METHODS.toArray(new String[0]))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
        return Helpers.createProxy(cls, values, params, Collections.singletonList(listener), (ElementMatcher<MethodDescription>)extraMatcher);
    }
}

