/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.proxy;

import io.appium.java_client.proxy.MethodCallListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;

class ProxyListenersContainer {
    private static ProxyListenersContainer INSTANCE;
    private final Semaphore listenersGuard = new Semaphore(1);
    private final List<Pair<WeakReference<?>, Collection<MethodCallListener>>> listenerPairs = new LinkedList();

    public static synchronized ProxyListenersContainer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProxyListenersContainer();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T setListeners(T proxyInstance, Collection<MethodCallListener> listeners) {
        try {
            this.listenersGuard.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            int i = 0;
            boolean wasInstancePresent = false;
            while (i < this.listenerPairs.size()) {
                Pair<WeakReference<?>, Collection<MethodCallListener>> pair = this.listenerPairs.get(i);
                Object key = pair.getKey().get();
                if (key == null) {
                    this.listenerPairs.remove(i);
                    continue;
                }
                if (key == proxyInstance) {
                    pair.setValue(List.copyOf(listeners));
                    wasInstancePresent = true;
                }
                ++i;
            }
            if (!wasInstancePresent) {
                this.listenerPairs.add(new Pair<WeakReference<T>, List<MethodCallListener>>(new WeakReference<T>(proxyInstance), List.copyOf(listeners)));
            }
        }
        finally {
            this.listenersGuard.release();
        }
        return proxyInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MethodCallListener> getListeners(Object proxyInstance) {
        try {
            this.listenersGuard.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            int i = 0;
            Collection<MethodCallListener> result = Collections.emptyList();
            while (i < this.listenerPairs.size()) {
                Pair<WeakReference<?>, Collection<MethodCallListener>> pair = this.listenerPairs.get(i);
                Object key = pair.getKey().get();
                if (key == null) {
                    this.listenerPairs.remove(i);
                    continue;
                }
                if (key == proxyInstance) {
                    result = pair.getValue();
                }
                ++i;
            }
            List<MethodCallListener> list = result;
            return list;
        }
        finally {
            this.listenersGuard.release();
        }
    }

    private ProxyListenersContainer() {
    }

    private static class Pair<K, V> {
        private final K key;
        private V value;

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

