/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.thymeleaf.feel;

import io.camunda.thymeleaf.feel.config.ThymeleafConfig;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.impl.SpiServiceLoader;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.IStandardVariableExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import scala.util.Either;

public class FeelExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    private FeelEngine feelEngine = null;
    DateTimeFormatter datetimeFormatter = null;
    DateTimeFormatter dateFormatter = null;
    private String datetimePattern = "dd/MM/yyyy - HH:mm:ss";
    private String datePattern = "dd/MM/yyy";

    public FeelExpressionEvaluator() {
    }

    public FeelExpressionEvaluator(ThymeleafConfig config) {
        this.datePattern = config.getDatePattern();
        this.datetimePattern = config.getDateTimePattern();
    }

    private FeelEngine getFeelEngine() {
        if (this.feelEngine == null) {
            this.feelEngine = new FeelEngine.Builder().valueMapper(SpiServiceLoader.loadValueMapper()).functionProvider(SpiServiceLoader.loadFunctionProvider()).build();
        }
        return this.feelEngine;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = DateTimeFormatter.ofPattern(this.datetimePattern);
        }
        return this.dateFormatter;
    }

    public DateTimeFormatter getDateFormatter() {
        if (this.datetimeFormatter == null) {
            this.datetimeFormatter = DateTimeFormatter.ofPattern(this.datePattern);
        }
        return this.datetimeFormatter;
    }

    public Object evaluate(IExpressionContext context, IStandardVariableExpression expression, StandardExpressionExecutionContext expContext) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (String name : context.getVariableNames()) {
            variables.put(name, context.getVariable(name));
        }
        Either result = this.getFeelEngine().evalExpression(expression.getExpression(), variables);
        if (result.isRight()) {
            Object value = result.right().get();
            if (value instanceof ZonedDateTime) {
                return ((ZonedDateTime)value).format(this.getDateTimeFormatter());
            }
            if (value instanceof LocalDate) {
                return ((LocalDate)value).format(this.getDateFormatter());
            }
            return value;
        }
        FeelEngine.Failure failure = (FeelEngine.Failure)result.left().get();
        throw new RuntimeException(failure.message());
    }
}

