/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.thymeleaf.feel;

import io.camunda.thymeleaf.feel.FeelExpressionEvaluator;
import io.camunda.thymeleaf.feel.ThymeleafCustomResourceResolver;
import io.camunda.thymeleaf.feel.config.ThymeleafConfig;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class TemplateEngineFactory {
    private static final String DEFAULT = "defaultEngine";
    private static Map<String, TemplateEngine> enginesMap = new HashMap<String, TemplateEngine>();
    private static TemplateEngine templateEngine;

    public static TemplateEngine getTemplateEngine() {
        if (enginesMap.containsKey(DEFAULT)) {
            return enginesMap.get(DEFAULT);
        }
        return TemplateEngineFactory.getTemplateEngine(DEFAULT, new ThymeleafConfig());
    }

    public static TemplateEngine getTemplateEngine(ThymeleafConfig config) {
        if (enginesMap.containsKey(DEFAULT)) {
            return enginesMap.get(DEFAULT);
        }
        return TemplateEngineFactory.getTemplateEngine(DEFAULT, config);
    }

    public static TemplateEngine getTemplateEngine(String name) {
        if (enginesMap.containsKey(name)) {
            return enginesMap.get(name);
        }
        return TemplateEngineFactory.getTemplateEngine(name, new ThymeleafConfig());
    }

    public static synchronized TemplateEngine getTemplateEngine(String name, ThymeleafConfig config) {
        Object resolver;
        if (enginesMap.containsKey(name)) {
            return enginesMap.get(name);
        }
        templateEngine = new TemplateEngine();
        if (config.getCustomTemplateResolver() == null) {
            resolver = new ClassLoaderTemplateResolver();
            resolver.setTemplateMode(config.getMode());
            resolver.setCharacterEncoding(config.getEncoding());
            resolver.setPrefix(config.getPrefix());
            resolver.setSuffix(config.getSuffix());
            templateEngine.setTemplateResolver((ITemplateResolver)resolver);
        } else {
            resolver = new ThymeleafCustomResourceResolver(config);
            templateEngine.setTemplateResolver((ITemplateResolver)resolver);
        }
        if (config.isFeelExpressions()) {
            for (IDialect dialect : templateEngine.getDialects()) {
                if (!(dialect instanceof StandardDialect)) continue;
                ((StandardDialect)dialect).setVariableExpressionEvaluator((IStandardVariableExpressionEvaluator)new FeelExpressionEvaluator(config));
            }
        }
        enginesMap.put(name, templateEngine);
        return templateEngine;
    }
}

