/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.servlets.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.metadata.KeyDescriptorMetaDataBuilder;
import org.picketlink.identity.federation.api.util.KeyUtil;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.config.MetadataProviderType;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.IMetadataProvider;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLMetadataWriter;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.RoleDescriptorType;
import org.picketlink.identity.federation.web.servlets.saml.SecurityActions;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.w3c.dom.Element;

public class MetadataServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(MetadataServlet.class);
    private final boolean trace = log.isTraceEnabled();
    private String configFileLocation = "/WEB-INF/picketlink.xml";
    private transient MetadataProviderType metadataProviderType = null;
    private transient IMetadataProvider<?> metadataProvider = null;
    private transient EntityDescriptorType metadata;
    private String signingAlias = null;
    private String encryptingAlias = null;
    private TrustKeyManager keyManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            InputStream is;
            ServletContext context = config.getServletContext();
            String configL = config.getInitParameter("configFile");
            if (StringUtil.isNotNull(configL)) {
                this.configFileLocation = configL;
            }
            if (this.trace) {
                log.trace((Object)("Config File Location=" + this.configFileLocation));
            }
            if ((is = context.getResourceAsStream(this.configFileLocation)) == null) {
                throw new RuntimeException("PL00018: Resource not found:" + this.configFileLocation + " missing");
            }
            this.signingAlias = config.getInitParameter("signingAlias");
            this.encryptingAlias = config.getInitParameter("encryptingAlias");
            IDPType providerType = ConfigurationUtil.getIDPConfiguration(is);
            this.metadataProviderType = providerType.getMetaDataProvider();
            String fqn = this.metadataProviderType.getClassName();
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), fqn);
            this.metadataProvider = (IMetadataProvider)clazz.newInstance();
            List<KeyValueType> keyValues = this.metadataProviderType.getOption();
            HashMap<String, String> options = new HashMap<String, String>();
            if (keyValues != null) {
                for (KeyValueType kvt : keyValues) {
                    options.put(kvt.getKey(), kvt.getValue());
                }
            }
            this.metadataProvider.init(options);
            if (this.metadataProvider.isMultiple()) {
                throw new RuntimeException("PL00082: Not Implemented Yet:Multiple Entities not currently supported");
            }
            String fileInjectionStr = this.metadataProvider.requireFileInjection();
            if (StringUtil.isNotNull(fileInjectionStr)) {
                this.metadataProvider.injectFileStream(context.getResourceAsStream(fileInjectionStr));
            }
            this.metadata = (EntityDescriptorType)this.metadataProvider.getMetaData();
            KeyProviderType keyProvider = providerType.getKeyProvider();
            this.signingAlias = keyProvider.getSigningAlias();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List<AuthPropertyType> authProperties = CoreConfigUtil.getKeyProviderProperties(keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            Certificate cert = this.keyManager.getCertificate(this.signingAlias);
            Element keyInfo = KeyUtil.getKeyInfo(cert);
            KeyDescriptorType keyDescriptor = KeyDescriptorMetaDataBuilder.createKeyDescriptor(keyInfo, null, 0, true, false);
            this.updateKeyDescriptor(this.metadata, keyDescriptor);
            if (this.encryptingAlias != null) {
                cert = this.keyManager.getCertificate(this.encryptingAlias);
                keyInfo = KeyUtil.getKeyInfo(cert);
                String certAlgo = cert.getPublicKey().getAlgorithm();
                keyDescriptor = KeyDescriptorMetaDataBuilder.createKeyDescriptor(keyInfo, XMLEncryptionUtil.getEncryptionURL(certAlgo), XMLEncryptionUtil.getEncryptionKeySize(certAlgo), false, true);
                this.updateKeyDescriptor(this.metadata, keyDescriptor);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception in starting servlet:", (Throwable)e);
            throw new ServletException("PL00102: Processing Exception:Unable to start servlet");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType(JBossSAMLConstants.METADATA_MIME.get());
        ServletOutputStream os = resp.getOutputStream();
        try {
            XMLStreamWriter streamWriter = StaxUtil.getXMLStreamWriter((OutputStream)os);
            SAMLMetadataWriter writer = new SAMLMetadataWriter(streamWriter);
            writer.writeEntityDescriptor(this.metadata);
        }
        catch (ProcessingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void updateKeyDescriptor(EntityDescriptorType entityD, KeyDescriptorType keyD) {
        List<EntityDescriptorType.EDTDescriptorChoiceType> objs = entityD.getChoiceType().get(0).getDescriptors();
        if (objs != null) {
            for (EntityDescriptorType.EDTDescriptorChoiceType roleD : objs) {
                RoleDescriptorType roleDescriptor = roleD.getRoleDescriptor();
                roleDescriptor.addKeyDescriptor(keyD);
            }
        }
    }
}

