/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;

public final class FutureServiceValue<T>
implements Future<T> {
    private final ServiceController<T> controller;
    private final ServiceController.State expectedState;

    public FutureServiceValue(ServiceController<T> controller) {
        this(controller, ServiceController.State.UP);
    }

    public FutureServiceValue(ServiceController<T> controller, ServiceController.State state) {
        if (controller == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("controller");
        }
        if (state == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("state");
        }
        this.controller = controller;
        this.expectedState = state;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.controller.getState() == this.expectedState;
    }

    @Override
    public T get() throws ExecutionException {
        try {
            return this.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        return this.getValue(timeout, unit);
    }

    private T getValue(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        Object cause;
        if (this.controller.getState() == this.expectedState) {
            return (T)this.controller.getValue();
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final FutureServiceValue futureServiceValue = this;
        final String serviceName = this.controller.getName().getCanonicalName();
        AbstractServiceListener listener = new AbstractServiceListener<T>(){

            public void listenerAdded(ServiceController<? extends T> controller) {
                ServiceController.State state = controller.getState();
                if (state == FutureServiceValue.this.expectedState || state == ServiceController.State.START_FAILED) {
                    this.listenerDone(controller);
                }
            }

            public void transition(ServiceController<? extends T> controller, ServiceController.Transition transition) {
                FrameworkLogger.LOGGER.tracef("transition %s %s => %s", futureServiceValue, serviceName, transition);
                if (FutureServiceValue.this.expectedState == ServiceController.State.UP) {
                    switch (transition) {
                        case STARTING_to_UP: 
                        case STARTING_to_START_FAILED: {
                            this.listenerDone(controller);
                        }
                    }
                } else if (FutureServiceValue.this.expectedState == ServiceController.State.DOWN) {
                    switch (transition) {
                        case STOPPING_to_DOWN: 
                        case REMOVING_to_DOWN: 
                        case WAITING_to_DOWN: {
                            this.listenerDone(controller);
                        }
                    }
                } else if (FutureServiceValue.this.expectedState == ServiceController.State.REMOVED) {
                    switch (transition) {
                        case REMOVING_to_REMOVED: {
                            this.listenerDone(controller);
                        }
                    }
                }
            }

            private void listenerDone(ServiceController<? extends T> controller) {
                controller.removeListener((ServiceListener)this);
                latch.countDown();
            }
        };
        this.controller.addListener((ServiceListener)listener);
        try {
            if (!latch.await(timeout, unit)) {
                TimeoutException ex = FrameworkMessages.MESSAGES.timeoutGettingService(serviceName);
                this.processTimeoutException(ex);
                throw ex;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.controller.getState() == this.expectedState) {
            return (T)this.controller.getValue();
        }
        StartException startException = this.controller.getStartException();
        Object object = cause = startException != null ? startException.getCause() : startException;
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw FrameworkMessages.MESSAGES.executionCannotGetServiceValue((Throwable)cause, serviceName);
    }

    private void processTimeoutException(TimeoutException exception) {
        ThreadInfo[] infos;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        Set unavailableDependencies = this.controller.getImmediateUnavailableDependencies();
        out.println("Unavailable dependencies: " + unavailableDependencies);
        this.controller.getServiceContainer().dumpServices(out);
        String serviceName = this.controller.getName().getCanonicalName();
        FrameworkLogger.LOGGER.debugf("Cannot get service value for: %s\n%s", serviceName, new String(baos.toByteArray()));
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = bean.dumpAllThreads(true, true)) {
            if (!info.getThreadName().contains("MSC")) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append("ThreadInfo: " + info);
            FrameworkLogger.LOGGER.errorf("%s", buffer);
        }
    }
}

