/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkState;

abstract class AbstractBundleService<T extends AbstractBundleState>
implements Service<T> {
    private final FrameworkState frameworkState;

    AbstractBundleService(FrameworkState frameworkState) {
        this.frameworkState = frameworkState;
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    BundleManagerPlugin getBundleManager() {
        return this.frameworkState.getBundleManager();
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        FrameworkLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        FrameworkLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public T getValue() {
        return this.getBundleState();
    }

    abstract T getBundleState();
}

