/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.AutoInstallComplete;
import org.jboss.osgi.framework.AutoInstallHandler;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.spi.util.StringPropertyReplacer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

final class DefaultAutoInstallHandler
extends AbstractPluginService<AutoInstallHandler>
implements AutoInstallHandler {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();

    static void addIntegrationService(ServiceRegistry registry, ServiceTarget serviceTarget) {
        if (registry.getService(IntegrationServices.AUTOINSTALL_HANDLER) == null) {
            DefaultAutoInstallHandler service = new DefaultAutoInstallHandler();
            ServiceBuilder builder = serviceTarget.addService(IntegrationServices.AUTOINSTALL_HANDLER, (Service)service);
            builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, service.injectedBundleManager);
            builder.addDependency(Services.FRAMEWORK_CREATE);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }
    }

    private DefaultAutoInstallHandler() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        URL url2;
        super.start(context);
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        final ArrayList<URL> autoInstall = new ArrayList<URL>();
        ArrayList<URL> autoStart = new ArrayList<URL>();
        String propValue = (String)bundleManager.getProperty("org.jboss.osgi.auto.install");
        if (propValue != null) {
            for (String path : propValue.split(",")) {
                url2 = this.toURL(bundleManager, path.trim());
                if (url2 == null) continue;
                autoInstall.add(url2);
            }
        }
        if ((propValue = (String)bundleManager.getProperty("org.jboss.osgi.auto.start")) != null) {
            for (String path : propValue.split(",")) {
                url2 = this.toURL(bundleManager, path.trim());
                if (url2 == null) continue;
                autoStart.add(url2);
            }
        }
        autoInstall.addAll(autoStart);
        AutoInstallComplete installComplete = new AutoInstallComplete(){

            @Override
            protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
                return autoInstall.size() == trackedServices.size();
            }
        };
        ServiceBuilder builder = installComplete.install(context.getChildTarget());
        if (autoInstall.isEmpty()) {
            builder.install();
        } else {
            ServiceListener listener = installComplete.getListener();
            for (URL url2 : autoInstall) {
                try {
                    BundleInfo info = BundleInfo.createBundleInfo((URL)url2);
                    Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
                    dep.setAutoStart(autoStart.contains(url2));
                    bundleManager.installBundle(dep, (ServiceListener<Bundle>)listener);
                }
                catch (BundleException ex) {
                    FrameworkLogger.LOGGER.errorStateCannotInstallInitialBundle(ex, url2.toExternalForm());
                }
            }
        }
    }

    public DefaultAutoInstallHandler getValue() {
        return this;
    }

    private URL toURL(final BundleManagerPlugin bundleManager, String path) {
        URL pathURL = null;
        StringPropertyReplacer.PropertyProvider provider = new StringPropertyReplacer.PropertyProvider(){

            public String getProperty(String key) {
                return (String)bundleManager.getProperty(key);
            }
        };
        String realPath = StringPropertyReplacer.replaceProperties((String)path, (StringPropertyReplacer.PropertyProvider)provider);
        try {
            pathURL = new URL(realPath);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (pathURL == null) {
            try {
                File file = new File(realPath);
                if (file.exists()) {
                    pathURL = file.toURI().toURL();
                }
            }
            catch (MalformedURLException ex) {
                throw FrameworkMessages.MESSAGES.illegalArgumentInvalidPath(ex, realPath);
            }
        }
        if (pathURL == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentInvalidPath(null, realPath);
        }
        return pathURL;
    }
}

