/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.URLResource;
import org.jboss.osgi.framework.util.VirtualFileResourceLoader;

final class RevisionContentResourceLoader
implements ResourceLoader {
    private final RevisionContent revContent;
    private final VirtualFileResourceLoader delegate;

    RevisionContentResourceLoader(RevisionContent revContent) {
        assert (revContent != null) : "Null revContent";
        this.delegate = new VirtualFileResourceLoader(revContent.getVirtualFile());
        this.revContent = revContent;
    }

    public String getRootName() {
        return this.delegate.getRootName();
    }

    public ClassSpec getClassSpec(String fileName) throws IOException {
        return this.delegate.getClassSpec(fileName);
    }

    public PackageSpec getPackageSpec(String name) throws IOException {
        return this.delegate.getPackageSpec(name);
    }

    public Resource getResource(String path) {
        URL url = this.revContent.getEntry(path);
        return url != null ? new URLResource(url) : null;
    }

    public String getLibrary(String name) {
        return null;
    }

    public Collection<String> getPaths() {
        return this.delegate.getPaths();
    }
}

