/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.StorageState;
import org.jboss.osgi.framework.TypeAdaptor;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.spi.ConstantsHelper;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;

abstract class UserBundleState
extends AbstractBundleState
implements TypeAdaptor {
    private final Semaphore uninstallSemaphore = new Semaphore(1);
    private final ServiceName serviceName;
    private final List<UserBundleRevision> revisions = new CopyOnWriteArrayList<UserBundleRevision>();
    private Dictionary<String, String> headersOnUninstall;
    private BundleStoragePlugin.InternalStorageState storageState;

    UserBundleState(FrameworkState frameworkState, long bundleId, Deployment dep) {
        super(frameworkState, bundleId, dep.getSymbolicName());
        this.serviceName = BundleManagerPlugin.getServiceName(dep);
    }

    static UserBundleState assertBundleState(Bundle bundle2) {
        bundle2 = AbstractBundleState.assertBundleState(bundle2);
        assert (bundle2 instanceof UserBundleState) : "Not an UserBundleState: " + bundle2;
        return (UserBundleState)bundle2;
    }

    @Override
    BundleStoragePlugin.InternalStorageState getStorageState() {
        return this.storageState;
    }

    public String getLocation() {
        return this.getCurrentBundleRevision().getLocation();
    }

    Deployment getDeployment() {
        return this.getCurrentBundleRevision().getDeployment();
    }

    RevisionContent getFirstContentRoot() {
        return this.getCurrentBundleRevision().getRootContent();
    }

    List<RevisionContent> getContentRoots() {
        return this.getCurrentBundleRevision().getContentList();
    }

    @Override
    boolean isSingleton() {
        return this.getOSGiMetaData().isSingleton();
    }

    UserBundleRevision createRevision(Deployment deployment) throws BundleException {
        UserBundleRevision revision = this.createRevisionInternal(deployment);
        this.addRevision(revision);
        return revision;
    }

    abstract void initLazyActivation();

    abstract UserBundleRevision createRevisionInternal(Deployment var1) throws BundleException;

    @Override
    public <T> T adapt(Class<T> type) {
        Object result = null;
        if (type.isAssignableFrom(Deployment.class)) {
            result = this.getDeployment();
        } else if (type.isAssignableFrom(StorageState.class)) {
            result = this.getStorageState();
        } else if (type.isAssignableFrom(OSGiMetaData.class)) {
            result = this.getOSGiMetaData();
        }
        return (T)result;
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (this.headersOnUninstall != null) {
            return this.headersOnUninstall;
        }
        return super.getHeaders(locale);
    }

    @Override
    ServiceName getServiceName(int state) {
        return this.serviceName.append(new String[]{ConstantsHelper.bundleState((int)state)});
    }

    void addRevision(UserBundleRevision rev) {
        this.revisions.add(0, rev);
    }

    @Override
    UserBundleRevision getCurrentBundleRevision() {
        return this.revisions.get(0);
    }

    @Override
    List<AbstractBundleRevision> getAllBundleRevisions() {
        ArrayList<UserBundleRevision> result = new ArrayList<UserBundleRevision>(this.revisions);
        return Collections.unmodifiableList(result);
    }

    void clearOldRevisions() {
        UserBundleRevision rev = this.getCurrentBundleRevision();
        this.revisions.clear();
        this.revisions.add(rev);
    }

    @Override
    AbstractBundleRevision getBundleRevisionById(int revisionId) {
        for (UserBundleRevision rev : this.revisions) {
            if (rev.getRevisionId() != revisionId) continue;
            return rev;
        }
        return null;
    }

    boolean aquireUninstallLock() {
        try {
            FrameworkLogger.LOGGER.tracef("Aquire uninstall lock: %s", this);
            boolean result = this.uninstallSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (!result) {
                FrameworkLogger.LOGGER.errorCannotAquireUninstallLock(this);
            }
            return result;
        }
        catch (InterruptedException ex) {
            FrameworkLogger.LOGGER.debugf("Interupted while trying to uninstall bundle: %s", this);
            return false;
        }
    }

    void releaseUninstallLock() {
        FrameworkLogger.LOGGER.tracef("Release uninstall lock: %s", this);
        this.uninstallSemaphore.release();
    }

    boolean hasActiveWires() {
        BundleWiring wiring = this.getCurrentBundleRevision().getWiring();
        return wiring != null ? wiring.isInUse() : false;
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
        int state;
        boolean restart = false;
        if (!(this.isFragment() || (state = this.getState()) != 32 && state != 8 && state != 16)) {
            this.stopInternal(1);
            if (state != 16) {
                restart = true;
            }
        }
        this.changeState(2, 64);
        this.getBundleManager().setServiceMode(this.getServiceName(4), ServiceController.Mode.NEVER);
        try {
            this.createUpdateRevision(input);
        }
        catch (BundleException ex) {
            if (restart) {
                this.startInternal(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            BundleException be = new BundleException("Problem updating bundle");
            be.initCause((Throwable)ex);
            if (restart) {
                this.startInternal(1);
            }
            throw be;
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(this, 8);
        if (restart) {
            try {
                this.startInternal(1);
            }
            catch (BundleException e) {
                eventsPlugin.fireFrameworkEvent(this, 2, e);
            }
        }
    }

    private void createUpdateRevision(InputStream input) throws Exception {
        VirtualFile rootFile = null;
        if (input == null) {
            String updateLocation = this.getOSGiMetaData().getHeader("Bundle-UpdateLocation");
            if (updateLocation != null) {
                URL updateURL = new URL(updateLocation);
                rootFile = AbstractVFS.toVirtualFile((URL)updateURL);
            } else {
                rootFile = this.getFirstContentRoot().getVirtualFile();
            }
        }
        if (rootFile == null && input != null) {
            rootFile = AbstractVFS.toVirtualFile((InputStream)input);
        }
        BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
        BundleStoragePlugin.InternalStorageState storageState = this.createStorageState(storagePlugin, this.getLocation(), rootFile);
        try {
            DeploymentFactoryPlugin deploymentPlugin = this.getFrameworkState().getDeploymentFactoryPlugin();
            Deployment dep = deploymentPlugin.createDeployment(storageState);
            OSGiMetaData metadata = deploymentPlugin.createOSGiMetaData(dep);
            dep.addAttachment(OSGiMetaData.class, (Object)metadata);
            dep.addAttachment(Bundle.class, (Object)this);
            UserBundleRevision brev = this.createRevision(dep);
            XEnvironment env = this.getFrameworkState().getEnvironment();
            env.installResources(new XResource[]{brev});
        }
        catch (BundleException ex) {
            storagePlugin.deleteStorageState(storageState);
            throw ex;
        }
        catch (RuntimeException ex) {
            storagePlugin.deleteStorageState(storageState);
            throw ex;
        }
    }

    BundleStoragePlugin.InternalStorageState createStorageState(Deployment dep) throws BundleException {
        StorageState attachedState = (StorageState)dep.getAttachment(StorageState.class);
        if (attachedState == null) {
            String location = dep.getLocation();
            VirtualFile rootFile = dep.getRoot();
            try {
                BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
                Integer startlevel = dep.getStartLevel();
                if (startlevel == null) {
                    startlevel = this.getCoreServices().getStartLevel().getInitialBundleStartLevel();
                }
                this.storageState = storagePlugin.createStorageState(this.getBundleId(), location, startlevel, rootFile);
                dep.addAttachment(StorageState.class, (Object)this.storageState);
            }
            catch (IOException ex) {
                throw FrameworkMessages.MESSAGES.bundleCannotSetupStorage(ex, rootFile);
            }
        } else {
            this.storageState = (BundleStoragePlugin.InternalStorageState)attachedState;
        }
        return this.storageState;
    }

    private BundleStoragePlugin.InternalStorageState createStorageState(BundleStoragePlugin storagePlugin, String location, VirtualFile rootFile) throws BundleException {
        BundleStoragePlugin.InternalStorageState storageState;
        try {
            int startlevel = this.getCoreServices().getStartLevel().getInitialBundleStartLevel();
            storageState = storagePlugin.createStorageState(this.getBundleId(), location, startlevel, rootFile);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.bundleCannotSetupStorage(ex, rootFile);
        }
        return storageState;
    }

    void refresh() throws BundleException {
        this.assertNotUninstalled();
        if (!this.isResolved()) {
            throw FrameworkMessages.MESSAGES.illegalStateRefreshUnresolvedBundle(this);
        }
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        UserBundleRevision currentRev = this.getCurrentBundleRevision();
        for (AbstractBundleRevision brev : this.getAllBundleRevisions()) {
            XEnvironment env = this.getFrameworkState().getEnvironment();
            if (currentRev != brev) {
                env.uninstallResources(new XResource[]{brev});
            }
            if (brev instanceof HostBundleRevision) {
                HostBundleRevision hostRev = (HostBundleRevision)brev;
                for (FragmentBundleRevision fragRev : hostRev.getAttachedFragments()) {
                    if (fragRev == fragRev.getBundleState().getCurrentBundleRevision()) continue;
                    env.uninstallResources(new XResource[]{fragRev});
                }
            }
            ModuleIdentifier identifier = brev.getModuleIdentifier();
            moduleManager.removeModule(identifier);
        }
        this.clearOldRevisions();
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(this, 64);
        currentRev.refreshRevision();
        this.changeState(2);
        this.getBundleManager().setServiceMode(this.getServiceName(4), ServiceController.Mode.NEVER);
    }

    @Override
    void uninstallInternal() throws BundleException {
        this.headersOnUninstall = this.getHeaders(null);
        BundleInstallHandler installHandler = this.getCoreServices().getInstallHandler();
        installHandler.uninstallBundle(this.getDeployment());
    }

    void removeServices() {
        FrameworkLogger.LOGGER.debugf("Remove services for: %s", this);
        BundleManagerPlugin bundleManager = this.getBundleManager();
        bundleManager.setServiceMode(this.getServiceName(32), ServiceController.Mode.REMOVE);
        bundleManager.setServiceMode(this.getServiceName(4), ServiceController.Mode.REMOVE);
        bundleManager.setServiceMode(this.getServiceName(2), ServiceController.Mode.REMOVE);
    }
}

