/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;

public class BundleInstallService
extends AbstractService<Void> {
    static final ServiceName SERVICE_NAME_BASE = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"bundle", "install"});
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final Deployment deployment;

    private BundleInstallService(Deployment deployment) {
        this.deployment = deployment;
    }

    public static ServiceName addService(DeploymentPhaseContext phaseContext, Deployment deployment) {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        BundleInstallService service = new BundleInstallService(deployment);
        String contextName = depUnit.getName();
        ServiceName serviceName = BundleInstallService.getServiceName(depUnit);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(Services.deploymentUnitName((String)contextName));
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_ACTIVE);
        builder.install();
        return serviceName;
    }

    private static ServiceName getServiceName(DeploymentUnit depUnit) {
        ServiceName deploymentServiceName = Services.deploymentUnitName((String)depUnit.getName());
        return SERVICE_NAME_BASE.append(new String[]{deploymentServiceName.getSimpleName()});
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        try {
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            bundleManager.installBundle(this.deployment, null);
        }
        catch (Throwable th) {
            throw OSGiMessages.MESSAGES.startFailedToInstallDeployment(th, this.deployment);
        }
    }

    public synchronized void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
        try {
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            bundleManager.uninstallBundle(this.deployment);
        }
        catch (Throwable t) {
            OSGiLogger.LOGGER.errorFailedToUninstallDeployment(t, this.deployment);
        }
    }
}

