/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.osgi.management.ActivateOperationHandler;
import org.jboss.as.osgi.management.ActivationAttributeHandler;
import org.jboss.as.osgi.management.BundleResourceHandler;
import org.jboss.as.osgi.management.StartLevelHandler;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.OSGiCapabilityAdd;
import org.jboss.as.osgi.parser.OSGiCapabilityRemove;
import org.jboss.as.osgi.parser.OSGiDescriptionProviders;
import org.jboss.as.osgi.parser.OSGiFrameworkPropertyAdd;
import org.jboss.as.osgi.parser.OSGiFrameworkPropertyRemove;
import org.jboss.as.osgi.parser.OSGiFrameworkPropertyWrite;
import org.jboss.as.osgi.parser.OSGiNamespace10Parser;
import org.jboss.as.osgi.parser.OSGiNamespace11Parser;
import org.jboss.as.osgi.parser.OSGiNamespace12Parser;
import org.jboss.as.osgi.parser.OSGiSubsystemAdd;
import org.jboss.as.osgi.parser.OSGiSubsystemDescribeHandler;
import org.jboss.as.osgi.parser.OSGiSubsystemWriter;
import org.jboss.staxmapper.XMLElementWriter;

public class OSGiExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "osgi";

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.VERSION_1_0.getUriString(), OSGiNamespace10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.VERSION_1_1.getUriString(), OSGiNamespace11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.VERSION_1_2.getUriString(), OSGiNamespace12Parser.INSTANCE);
    }

    public void initialize(ExtensionContext context) {
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(OSGiDescriptionProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)OSGiSubsystemAdd.INSTANCE, OSGiDescriptionProviders.SUBSYSTEM_ADD, false);
        registration.registerReadWriteAttribute("activation", null, (OperationStepHandler)ActivationAttributeHandler.INSTANCE, EnumSet.of(AttributeAccess.Flag.STORAGE_CONFIGURATION, AttributeAccess.Flag.RESTART_JVM));
        registration.registerOperationHandler("describe", (OperationStepHandler)OSGiSubsystemDescribeHandler.INSTANCE, OSGiDescriptionProviders.SUBSYSTEM_ADD, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, OSGiDescriptionProviders.SUBSYSTEM_REMOVE, false);
        ManagementResourceRegistration properties = registration.registerSubModel(PathElement.pathElement((String)"property"), OSGiDescriptionProviders.PROPERTY_DESCRIPTION);
        properties.registerOperationHandler("add", (OperationStepHandler)OSGiFrameworkPropertyAdd.INSTANCE, OSGiFrameworkPropertyAdd.DESCRIPTION, false);
        properties.registerOperationHandler("remove", (OperationStepHandler)OSGiFrameworkPropertyRemove.INSTANCE, OSGiFrameworkPropertyRemove.DESCRIPTION, false);
        properties.registerReadWriteAttribute("value", null, (OperationStepHandler)OSGiFrameworkPropertyWrite.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration capabilities = registration.registerSubModel(PathElement.pathElement((String)"capability"), OSGiDescriptionProviders.CAPABILITY_DESCRIPTION);
        capabilities.registerOperationHandler("add", (OperationStepHandler)OSGiCapabilityAdd.INSTANCE, OSGiCapabilityAdd.DESCRIPTION, false);
        capabilities.registerOperationHandler("remove", (OperationStepHandler)OSGiCapabilityRemove.INSTANCE, OSGiCapabilityRemove.DESCRIPTION, false);
        capabilities.registerReadOnlyAttribute("startlevel", null, AttributeAccess.Storage.RUNTIME);
        if (registerRuntimeOnly) {
            registration.registerOperationHandler("activate", (OperationStepHandler)ActivateOperationHandler.INSTANCE, OSGiDescriptionProviders.ACTIVATE_OPERATION, EnumSet.of(OperationEntry.Flag.RESTART_NONE));
            registration.registerReadWriteAttribute("startlevel", (OperationStepHandler)StartLevelHandler.READ_HANDLER, (OperationStepHandler)StartLevelHandler.WRITE_HANDLER, AttributeAccess.Storage.RUNTIME);
            BundleResourceHandler.INSTANCE.register(registration.registerSubModel(PathElement.pathElement((String)"bundle"), OSGiDescriptionProviders.BUNDLE_DESCRIPTION));
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)OSGiSubsystemWriter.INSTANCE);
    }
}

