/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.Logger;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLResourceResolver
implements XMLResolver,
EntityResolver,
LSResourceResolver {
    private static final Logger log = Logger.getLogger(XMLResourceResolver.class);
    private static Map entities = new ConcurrentHashMap();
    private static boolean warnOnNonFileURLs;
    private Map localEntities;
    private ThreadLocal<Boolean> entityResolved = new ThreadLocal();

    public static Map getEntityMap() {
        return Collections.unmodifiableMap(entities);
    }

    public static boolean isWarnOnNonFileURLs() {
        return warnOnNonFileURLs;
    }

    public static void setWarnOnNonFileURLs(boolean warnOnNonFileURLs) {
        XMLResourceResolver.warnOnNonFileURLs = warnOnNonFileURLs;
    }

    public static void registerEntity(String id, String dtdFileName) {
        entities.put(id, dtdFileName);
    }

    public synchronized void registerLocalEntity(String id, String dtdOrSchema) {
        if (this.localEntities == null) {
            this.localEntities = new ConcurrentHashMap();
        }
        this.localEntities.put(id, dtdOrSchema);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.entityResolved.set(Boolean.FALSE);
        if (publicId == null && systemId == null) {
            return null;
        }
        boolean trace = log.isTraceEnabled();
        boolean resolvePublicIdFirst = true;
        if (publicId != null && systemId != null) {
            String registeredSystemId = null;
            if (this.localEntities != null) {
                registeredSystemId = (String)this.localEntities.get(publicId);
            }
            if (registeredSystemId == null) {
                registeredSystemId = (String)entities.get(publicId);
            }
            if (registeredSystemId != null && !registeredSystemId.equals(systemId)) {
                resolvePublicIdFirst = false;
                if (trace) {
                    log.trace((Object)("systemId argument '" + systemId + "' for publicId '" + publicId + "' is different from the registered systemId '" + registeredSystemId + "', resolution will be based on the argument"));
                }
            }
        }
        InputSource inputSource = null;
        if (resolvePublicIdFirst) {
            inputSource = this.resolvePublicID(publicId, trace);
        }
        if (inputSource == null) {
            inputSource = this.resolveSystemID(systemId, trace);
        }
        if (inputSource == null) {
            inputSource = this.resolveClasspathName(systemId, trace);
        }
        if (inputSource == null) {
            inputSource = this.resolveSystemIDasURL(systemId, trace);
        }
        this.entityResolved.set(new Boolean(inputSource != null));
        if (inputSource == null) {
            log.debug((Object)("Cannot resolve [publicID=" + publicId + ",systemID=" + systemId + "]"));
        }
        return inputSource;
    }

    public boolean isEntityResolved() {
        Boolean value = this.entityResolved.get();
        return value != null ? value : false;
    }

    protected InputSource resolvePublicID(String publicId, boolean trace) {
        if (publicId == null) {
            return null;
        }
        if (trace) {
            log.trace((Object)("resolvePublicID, publicId=" + publicId));
        }
        InputSource inputSource = null;
        String filename = null;
        if (this.localEntities != null) {
            filename = (String)this.localEntities.get(publicId);
        }
        if (filename == null) {
            filename = (String)entities.get(publicId);
        }
        if (filename != null) {
            InputStream ins;
            if (trace) {
                log.trace((Object)("Found entity from publicId=" + publicId + " fileName=" + filename));
            }
            if ((ins = this.loadResource(filename, trace)) != null) {
                inputSource = new InputSource(ins);
                inputSource.setPublicId(publicId);
            } else {
                log.trace((Object)("Cannot load publicId from classpath resource: " + filename));
                inputSource = this.resolveSystemIDasURL(filename, trace);
                if (inputSource == null) {
                    log.warn((Object)("Cannot load publicId from resource: " + filename));
                }
            }
        }
        return inputSource;
    }

    protected InputSource resolveSystemID(String systemId, boolean trace) {
        if (systemId == null) {
            return null;
        }
        if (trace) {
            log.trace((Object)("resolveSystemID, systemId=" + systemId));
        }
        InputSource inputSource = null;
        String filename = null;
        if (this.localEntities != null) {
            filename = (String)this.localEntities.get(systemId);
        }
        if (filename == null) {
            filename = (String)entities.get(systemId);
        }
        if (filename != null) {
            InputStream ins;
            if (trace) {
                log.trace((Object)("Found entity systemId=" + systemId + " fileName=" + filename));
            }
            if ((ins = this.loadResource(filename, trace)) != null) {
                inputSource = new InputSource(ins);
                inputSource.setSystemId(systemId);
            } else {
                log.warn((Object)("Cannot load systemId from resource: " + filename));
            }
        }
        return inputSource;
    }

    protected InputSource resolveSystemIDasURL(String systemId, boolean trace) {
        InputSource inputSource;
        block11: {
            if (systemId == null) {
                return null;
            }
            if (trace) {
                log.trace((Object)("resolveSystemIDasURL, systemId=" + systemId));
            }
            inputSource = null;
            try {
                InputStream ins;
                if (trace) {
                    log.trace((Object)"Trying to resolve systemId as a URL");
                }
                URL url = new URL(systemId);
                if (warnOnNonFileURLs && !url.getProtocol().equalsIgnoreCase("file")) {
                    log.warn((Object)("Trying to resolve systemId as a non-file URL: " + systemId));
                }
                if ((ins = url.openStream()) != null) {
                    inputSource = new InputSource(ins);
                    inputSource.setSystemId(systemId);
                } else {
                    log.warn((Object)("Cannot load systemId as URL: " + systemId));
                }
                if (trace) {
                    log.trace((Object)"Resolved systemId as a URL");
                }
            }
            catch (MalformedURLException ignored) {
                if (trace) {
                    log.trace((Object)("SystemId is not a url: " + systemId), (Throwable)ignored);
                }
            }
            catch (IOException e) {
                if (!trace) break block11;
                log.trace((Object)("Failed to obtain URL.InputStream from systemId: " + systemId), (Throwable)e);
            }
        }
        return inputSource;
    }

    protected InputSource resolveClasspathName(String systemId, boolean trace) {
        String filename;
        block8: {
            if (systemId == null) {
                return null;
            }
            if (trace) {
                log.trace((Object)("resolveClasspathName, systemId=" + systemId));
            }
            filename = systemId;
            try {
                int slash;
                URI url = new URI(systemId);
                String path = url.getPath();
                if (path == null) {
                    path = url.getSchemeSpecificPart();
                }
                if ((filename = (slash = path.lastIndexOf(47)) >= 0 ? path.substring(slash + 1) : path).length() == 0) {
                    return null;
                }
                if (trace) {
                    log.trace((Object)("Mapped systemId to filename: " + filename));
                }
            }
            catch (URISyntaxException e) {
                if (!trace) break block8;
                log.trace((Object)"systemId: is not a URI, using systemId as resource", (Throwable)e);
            }
        }
        InputStream is = this.loadResource(filename, trace);
        InputSource inputSource = null;
        if (is != null) {
            inputSource = new InputSource(is);
            inputSource.setSystemId(systemId);
        }
        return inputSource;
    }

    protected InputStream loadResource(String resource, boolean trace) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = this.loadResource(classLoader, resource, trace);
        if (inputStream == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            inputStream = this.loadResource(classLoader, resource, trace);
        }
        return inputStream;
    }

    protected InputStream loadResource(ClassLoader loader, String resource, boolean trace) {
        URL url = loader.getResource(resource);
        if (url == null) {
            if (resource.endsWith(".dtd")) {
                resource = "dtd/" + resource;
            } else if (resource.endsWith(".xsd")) {
                resource = "schema/" + resource;
            }
            url = loader.getResource(resource);
        }
        InputStream inputStream = null;
        if (url != null) {
            if (trace) {
                log.trace((Object)(resource + " maps to URL: " + url));
            }
            try {
                inputStream = url.openStream();
            }
            catch (IOException e) {
                log.debug((Object)"Failed to open url stream", (Throwable)e);
            }
        }
        return inputStream;
    }

    @Override
    public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
        InputSource inputSource = null;
        try {
            inputSource = this.resolveEntity(publicID, systemID);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to resolve entity", (Throwable)e);
        }
        return inputSource != null ? inputSource.getByteStream() : null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicID, String systemID, String baseURI) {
        InputSource inputSource = null;
        try {
            inputSource = this.resolveEntity(publicID, systemID);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to resolve resource", (Throwable)e);
        }
        LSInputImpl result = null;
        if (inputSource != null) {
            result = new LSInputImpl(publicID, systemID, baseURI, inputSource);
        }
        return result;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                warnOnNonFileURLs = new Boolean(System.getProperty("org.jboss.resolver.warning", "false"));
                return null;
            }
        });
        XMLResourceResolver.registerEntity("-//W3C//DTD/XMLSCHEMA 200102//EN", "XMLSchema.dtd");
        XMLResourceResolver.registerEntity("http://www.w3.org/2001/XMLSchema.dtd", "XMLSchema.dtd");
        XMLResourceResolver.registerEntity("datatypes", "datatypes.dtd");
        XMLResourceResolver.registerEntity("http://www.w3.org/XML/1998/namespace", "xml.xsd");
        XMLResourceResolver.registerEntity("http://www.w3.org/2001/xml.xsd", "xml.xsd");
        XMLResourceResolver.registerEntity("http://www.w3.org/2005/05/xmlmime", "xml-media-types.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", "j2ee_1_4.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/javaee/javaee_5.xsd", "javaee_5.xsd");
        XMLResourceResolver.registerEntity("http://www.jboss.org/j2ee/schema/jboss-common_5_1.xsd", "jboss-common_5_1.xsd");
        XMLResourceResolver.registerEntity("http://schemas.xmlsoap.org/soap/encoding/", "soap-encoding_1_1.xsd");
        XMLResourceResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
        XMLResourceResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", "j2ee_web_services_1_1.xsd");
        XMLResourceResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd", "j2ee_jaxrpc_mapping_1_1.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/javaee/javaee_web_services_client_1_2.xsd", "javaee_web_services_client_1_2.xsd");
        XMLResourceResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "ejb-jar_1_1.dtd");
        XMLResourceResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "ejb-jar_2_0.dtd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd", "ejb-jar_2_1.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd", "ejb-jar_3_0.xsd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS//EN", "jboss.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS 2.4//EN", "jboss_2_4.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS 3.0//EN", "jboss_3_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS 3.2//EN", "jboss_3_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS 4.0//EN", "jboss_4_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS 4.2//EN", "jboss_4_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS 5.0//EN", "jboss_5_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS 5.1.EAP//EN", "jboss_5_1_eap.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS 6.0//EN", "jboss_6_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 3.0//EN", "jbosscmp-jdbc_3_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 3.2//EN", "jbosscmp-jdbc_3_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 4.0//EN", "jbosscmp-jdbc_4_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 4.2//EN", "jbosscmp-jdbc_4_2.dtd");
        XMLResourceResolver.registerEntity("http://www.jboss.org/j2ee/schema/jboss_5_0.xsd", "jboss_5_0.xsd");
        XMLResourceResolver.registerEntity("http://www.jboss.org/j2ee/schema/jboss_5_1.xsd", "jboss_5_1.xsd");
        XMLResourceResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "application_1_2.dtd");
        XMLResourceResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "application_1_3.dtd");
        XMLResourceResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "application-client_1_3.dtd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd", "application_1_4.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/javaee/application_5.xsd", "application_5.xsd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD J2EE Application 1.3//EN", "jboss-app_3_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD J2EE Application 1.3V2//EN", "jboss-app_3_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD J2EE Application 1.4//EN", "jboss-app_4_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD J2EE Application 4.2//EN", "jboss-app_4_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Java EE Application 5.0//EN", "jboss-app_5_0.dtd");
        XMLResourceResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "connector_1_0.dtd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd", "connector_1_5.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/connector_1_6.xsd", "connector_1_6.xsd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS JCA Config 1.0//EN", "jboss-ds_1_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS JCA Config 1.5//EN", "jboss-ds_1_5.dtd");
        XMLResourceResolver.registerEntity("http://www.jboss.org/j2ee/schema/jboss-ds_5_0.xsd", "jboss-ds_5_0.xsd");
        XMLResourceResolver.registerEntity("http://www.jboss.org/j2ee/schema/jboss-ra_1_0.xsd", "jboss-ra_1_0.xsd");
        XMLResourceResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
        XMLResourceResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "web-app_2_4.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", "web-app_2_5.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", "web-app_3_0.xsd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Application 2.2//EN", "jboss-web.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Application 2.3//EN", "jboss-web_3_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Application 2.3V2//EN", "jboss-web_3_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Application 2.4//EN", "jboss-web_4_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Application 4.2//EN", "jboss-web_4_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Application 5.0//EN", "jboss-web_5_0.dtd");
        XMLResourceResolver.registerEntity("http://www.jboss.org/j2ee/schema/jboss-web_5_1.xsd", "jboss-web_5_1.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd", "application-client_1_4.xsd");
        XMLResourceResolver.registerEntity("http://java.sun.com/xml/ns/javaee/application-client_5.xsd", "application-client_5.xsd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Application Client 3.2//EN", "jboss-client_3_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Application Client 4.0//EN", "jboss-client_4_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Application Client 4.2//EN", "jboss-client_4_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Application Client 5.0//EN", "jboss-client_5_0.dtd");
        XMLResourceResolver.registerEntity("http://www.jboss.org/j2ee/schema/jboss-client_5_1.xsd", "jboss-client_5_1.xsd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Service Reference 4.0//EN", "service-ref_4_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Service Reference 4.2//EN", "service-ref_4_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD Web Service Reference 5.0//EN", "service-ref_5_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD MBean Service 3.2//EN", "jboss-service_3_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD MBean Service 4.0//EN", "jboss-service_4_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD MBean Service 4.2//EN", "jboss-service_4_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD MBean Service 5.0//EN", "jboss-service_5_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.0//EN", "jboss_xmbean_1_0.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.1//EN", "jboss_xmbean_1_1.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.2//EN", "jboss_xmbean_1_2.dtd");
        XMLResourceResolver.registerEntity("-//JBoss//DTD JBOSS Security Config 3.0//EN", "security_config.dtd");
        XMLResourceResolver.registerEntity("http://www.jboss.org/j2ee/schema/security-config_4_0.xsd", "security-config_4_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:aop-deployer", "aop-deployer_1_1.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:aop-beans:1.0", "aop-beans_1_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:bean-deployer", "bean-deployer_1_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:bean-deployer:2.0", "bean-deployer_2_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:javabean:1.0", "javabean_1_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:javabean:2.0", "javabean_2_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:spring-beans:2.0", "mc-spring-beans_2_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:policy:1.0", "policy_1_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:osgi-beans:1.0", "osgi-beans_1_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:seam-components:1.0", "seam-components_1_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:security-config:4.1", "security-config_4_1.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:security-config:5.0", "security-config_5_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:jndi-binding-service:1.0", "jndi-binding-service_1_0.xsd");
        XMLResourceResolver.registerEntity("urn:jboss:user-roles:1.0", "user-roles_1_0.xsd");
    }

    private static class LSInputImpl
    implements LSInput {
        private final String systemID;
        private final String publicID;
        private final String baseURI;
        private final InputSource inputSource;

        public LSInputImpl(String publicID, String systemID, String baseURI, InputSource inputSource) {
            this.inputSource = inputSource;
            this.systemID = systemID;
            this.publicID = publicID;
            this.baseURI = baseURI;
        }

        @Override
        public Reader getCharacterStream() {
            return this.inputSource.getCharacterStream();
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return this.inputSource.getByteStream();
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemID;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return this.publicID;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }
}

