/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.appclient.parser.jboss;

import java.util.HashMap;
import java.util.Map;

public enum JBossClientElement {
    UNKNOWN(null),
    CALLBACK_HANDLER("callback-handler"),
    DEPENDS("depends"),
    JNDI_NAME("jndi-name"),
    METADATA_COMPLETE("metadata-complete");

    private final String elementName;
    private static final Map<String, JBossClientElement> ELEMENT_MAP;

    private JBossClientElement(String name) {
        this.elementName = name;
    }

    public String getLocalName() {
        return this.elementName;
    }

    public static JBossClientElement forName(String elementName) {
        JBossClientElement element = ELEMENT_MAP.get(elementName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, JBossClientElement> map = new HashMap<String, JBossClientElement>();
        for (JBossClientElement element : JBossClientElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        ELEMENT_MAP = map;
    }
}

