/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalOperationImpl;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.host.controller.mgmt.TransformingProxyController;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.threads.AsyncFuture;

class HostControllerUpdateTask {
    private final String name;
    private final ModelNode operation;
    private final OperationContext context;
    private final TransactionalProtocolClient client;
    private final PathAddress address;
    private final Transformers transformers;

    public HostControllerUpdateTask(String name, ModelNode operation, OperationContext context, TransformingProxyController proxyController) {
        this.name = name;
        this.client = proxyController.getProtocolClient();
        this.context = context;
        this.operation = operation;
        this.transformers = proxyController.getTransformers();
        this.address = proxyController.getProxyNodeAddress();
    }

    public AsyncFuture<ModelNode> execute(ProxyOperationListener listener) {
        boolean trace = DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled();
        if (trace) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Sending %s to %s", this.operation, this.name);
        }
        DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(this.context);
        DelegatingOperationAttachments operationAttachments = new DelegatingOperationAttachments(this.context);
        ProxyOperation proxyOperation = new ProxyOperation(this.name, this.operation, messageHandler, operationAttachments);
        SubsystemInfoOperationListener subsystemListener = new SubsystemInfoOperationListener(listener, this.transformers);
        try {
            return this.client.execute((TransactionalProtocolClient.TransactionalOperationListener)subsystemListener, (TransactionalProtocolClient.Operation)proxyOperation);
        }
        catch (IOException e) {
            TransactionalProtocolClient.PreparedOperation result = BlockingQueueOperationListener.FailedOperation.create((TransactionalProtocolClient.Operation)proxyOperation, (Throwable)e);
            subsystemListener.operationPrepared((TransactionalProtocolClient.PreparedOperation<ProxyOperation>)result);
            return result.getFinalResult();
        }
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }

        public void close() throws IOException {
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }

    private static class SubsystemInfoOperationListener
    implements TransactionalProtocolClient.TransactionalOperationListener<ProxyOperation> {
        private final ProxyOperationListener delegate;
        private final Transformers transformers;

        private SubsystemInfoOperationListener(ProxyOperationListener delegate, Transformers transformers) {
            this.delegate = delegate;
            this.transformers = transformers;
        }

        public void operationPrepared(TransactionalProtocolClient.PreparedOperation<ProxyOperation> prepared) {
            this.delegate.operationPrepared(prepared);
        }

        public void operationFailed(ProxyOperation operation, ModelNode result) {
            this.delegate.operationFailed((TransactionalProtocolClient.Operation)operation, result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ProxyOperation operation, ModelNode result) {
            try {
                this.storeSubsystemVersions(operation.getOperation(), result);
            }
            finally {
                this.delegate.operationComplete(operation, result);
            }
        }

        private void storeSubsystemVersions(ModelNode operation, ModelNode response) {
            PathAddress address;
            PathAddress pathAddress = address = operation.hasDefined("address") ? PathAddress.pathAddress((ModelNode)operation.get("address")) : PathAddress.EMPTY_ADDRESS;
            if (address.size() == 0 && "composite".equals(operation.get("operation").asString()) && response.hasDefined("result")) {
                List steps = operation.hasDefined("steps") ? operation.get("steps").asList() : Collections.emptyList();
                ModelNode result = response.get("result");
                for (int i = 0; i < steps.size(); ++i) {
                    ModelNode stepOp = (ModelNode)steps.get(i);
                    String resultID = "step-" + (i + 1);
                    if (!result.hasDefined(resultID)) continue;
                    this.storeSubsystemVersions(stepOp, result.get(resultID));
                }
            } else if (address.size() == 1 && "add".equals(operation.get("operation").asString()) && "extension".equals(address.getElement(0).getKey()) && response.hasDefined("result") && response.get("result").hasDefined("domain-results")) {
                TransformationTarget target = this.transformers.getTarget();
                for (Property p : response.get(new String[]{"result", "domain-results"}).asPropertyList()) {
                    String[] version = p.getValue().asString().split("\\.");
                    int major = Integer.parseInt(version[0]);
                    int minor = Integer.parseInt(version[1]);
                    target.addSubsystemVersion(p.getName(), major, minor);
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf("Registering subsystem %s for host %s with major version [%d] and minor version [%d]", new Object[]{p.getName(), address, major, minor});
                }
                response.get("result").set(new ModelNode());
            }
        }
    }

    static class ProxyOperationListener
    extends BlockingQueueOperationListener<ProxyOperation> {
        final boolean trace = DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled();

        ProxyOperationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationPrepared(TransactionalProtocolClient.PreparedOperation<ProxyOperation> prepared) {
            try {
                super.operationPrepared(prepared);
            }
            finally {
                if (this.trace) {
                    ModelNode result = prepared.getPreparedResult();
                    String hostName = ((ProxyOperation)prepared.getOperation()).getName();
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Received prepared result %s from %s", result, hostName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ProxyOperation operation, ModelNode result) {
            try {
                super.operationComplete((TransactionalProtocolClient.Operation)operation, result);
            }
            finally {
                if (this.trace) {
                    String hostName = operation.getName();
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Received final result %s from %s", result, hostName);
                }
            }
        }
    }

    static class ProxyOperation
    extends TransactionalOperationImpl {
        private final String name;

        protected ProxyOperation(String name, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) {
            super(operation, messageHandler, attachments);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

