/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractBindingBuilder;
import org.apache.neethi.Assertion;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsymmetricBindingHandler
extends AbstractBindingBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(AsymmetricBindingHandler.class);
    AsymmetricBinding abinding;
    private WSSecEncryptedKey encrKey;
    private String encryptedKeyId;
    private byte[] encryptedKeyValue;

    public AsymmetricBindingHandler(WSSConfig config, AsymmetricBinding binding, SOAPMessage saaj, WSSecHeader secHeader, AssertionInfoMap aim, SoapMessage message) {
        super(config, binding, saaj, secHeader, aim, message);
        this.abinding = binding;
        this.protectionOrder = binding.getProtectionOrder();
    }

    public void handleBinding() {
        WSSecTimestamp timestamp = this.createTimestamp();
        this.handleLayout(timestamp);
        if (this.abinding.getProtectionOrder() == SPConstants.ProtectionOrder.EncryptBeforeSigning) {
            this.doEncryptBeforeSign();
        } else {
            this.doSignBeforeEncrypt();
        }
    }

    private void doSignBeforeEncrypt() {
        try {
            TokenWrapper encToken;
            TokenWrapper initiatorWrapper = this.abinding.getInitiatorSignatureToken();
            if (initiatorWrapper == null) {
                initiatorWrapper = this.abinding.getInitiatorToken();
            }
            boolean attached = false;
            if (initiatorWrapper != null) {
                AssertionWrapper assertionWrapper;
                Token initiatorToken = initiatorWrapper.getToken();
                if (initiatorToken instanceof IssuedToken) {
                    SecurityToken secToken = this.getSecurityToken();
                    if (secToken == null) {
                        this.policyNotAsserted((Assertion)initiatorToken, "No intiator token id");
                        return;
                    }
                    this.policyAsserted((Assertion)initiatorToken);
                    if (this.includeToken(initiatorToken.getInclusion())) {
                        Element el = secToken.getToken();
                        this.addEncryptedKeyElement(this.cloneElement(el));
                        attached = true;
                    }
                } else if (initiatorToken instanceof SamlToken && (assertionWrapper = this.addSamlToken((SamlToken)initiatorToken)) != null) {
                    if (this.includeToken(initiatorToken.getInclusion())) {
                        this.addSupportingElement(assertionWrapper.toDOM((Document)this.saaj.getSOAPPart()));
                        this.storeAssertionAsSecurityToken(assertionWrapper);
                    }
                    this.policyAsserted((Assertion)initiatorToken);
                }
            }
            ArrayList<WSEncryptionPart> sigs = new ArrayList<WSEncryptionPart>();
            if (this.timestampEl != null) {
                WSEncryptionPart timestampPart = this.convertToEncryptionPart(this.timestampEl.getElement());
                sigs.add(timestampPart);
            }
            this.addSupportingTokens(sigs);
            if (this.isRequestor() && initiatorWrapper != null) {
                this.doSignature(initiatorWrapper, sigs, attached);
                this.doEndorse();
            } else if (!this.isRequestor()) {
                this.addSignatureConfirmation(sigs);
                TokenWrapper recipientSignatureToken = this.abinding.getRecipientSignatureToken();
                if (recipientSignatureToken == null) {
                    recipientSignatureToken = this.abinding.getRecipientToken();
                }
                if (recipientSignatureToken != null) {
                    this.doSignature(recipientSignatureToken, sigs, attached);
                }
            }
            List<WSEncryptionPart> enc = this.getEncryptedParts();
            if (this.abinding.isSignatureProtection()) {
                if (this.mainSigId != null) {
                    WSEncryptionPart sigPart = new WSEncryptionPart(this.mainSigId, "Element");
                    sigPart.setElement(this.bottomUpElement);
                    enc.add(sigPart);
                }
                if (this.sigConfList != null && !this.sigConfList.isEmpty()) {
                    enc.addAll(this.sigConfList);
                }
            }
            if (this.isRequestor()) {
                enc.addAll(this.encryptedTokensList);
                encToken = this.abinding.getRecipientEncryptionToken();
                if (encToken == null) {
                    encToken = this.abinding.getRecipientToken();
                }
            } else {
                encToken = this.abinding.getInitiatorEncryptionToken();
                if (encToken == null) {
                    encToken = this.abinding.getInitiatorToken();
                }
            }
            this.doEncryption(encToken, enc, false);
        }
        catch (Exception e) {
            String reason = e.getMessage();
            LOG.log(Level.WARNING, "Sign before encryption failed due to : " + reason);
            throw new Fault((Throwable)e);
        }
    }

    private void doEncryptBeforeSign() {
        TokenWrapper wrapper;
        Token encryptionToken = null;
        if (this.isRequestor()) {
            wrapper = this.abinding.getRecipientEncryptionToken();
            if (wrapper == null) {
                wrapper = this.abinding.getRecipientToken();
            }
        } else {
            wrapper = this.abinding.getInitiatorEncryptionToken();
            if (wrapper == null) {
                wrapper = this.abinding.getInitiatorToken();
            }
        }
        encryptionToken = wrapper.getToken();
        TokenWrapper initiatorWrapper = this.abinding.getInitiatorSignatureToken();
        if (initiatorWrapper == null) {
            initiatorWrapper = this.abinding.getInitiatorToken();
        }
        boolean attached = false;
        if (initiatorWrapper != null) {
            Token initiatorToken = initiatorWrapper.getToken();
            if (initiatorToken instanceof IssuedToken) {
                SecurityToken secToken = this.getSecurityToken();
                if (secToken == null) {
                    this.policyNotAsserted((Assertion)initiatorToken, "No intiator token id");
                    return;
                }
                this.policyAsserted((Assertion)initiatorToken);
                if (this.includeToken(initiatorToken.getInclusion())) {
                    Element el = secToken.getToken();
                    this.addEncryptedKeyElement(this.cloneElement(el));
                    attached = true;
                }
            } else if (initiatorToken instanceof SamlToken) {
                try {
                    AssertionWrapper assertionWrapper = this.addSamlToken((SamlToken)initiatorToken);
                    if (assertionWrapper != null) {
                        if (this.includeToken(initiatorToken.getInclusion())) {
                            this.addSupportingElement(assertionWrapper.toDOM((Document)this.saaj.getSOAPPart()));
                            this.storeAssertionAsSecurityToken(assertionWrapper);
                        }
                        this.policyAsserted((Assertion)initiatorToken);
                    }
                }
                catch (Exception e) {
                    String reason = e.getMessage();
                    LOG.log(Level.WARNING, "Encrypt before sign failed due to : " + reason);
                    throw new Fault((Throwable)e);
                }
            }
        }
        List<WSEncryptionPart> encrParts = null;
        List<WSEncryptionPart> sigParts = null;
        try {
            encrParts = this.getEncryptedParts();
            sigParts = this.getSignedParts();
        }
        catch (SOAPException ex) {
            throw new Fault((Throwable)ex);
        }
        if (encryptionToken != null && encrParts.size() > 0) {
            WSSecBase encrBase = this.doEncryption(wrapper, encrParts, true);
            this.handleEncryptedSignedHeaders(encrParts, sigParts);
            if (this.timestampEl != null) {
                WSEncryptionPart timestampPart = this.convertToEncryptionPart(this.timestampEl.getElement());
                sigParts.add(timestampPart);
            }
            if (this.isRequestor()) {
                try {
                    this.addSupportingTokens(sigParts);
                }
                catch (WSSecurityException ex) {
                    this.policyNotAsserted((Assertion)encryptionToken, ex.getMessage());
                }
            } else {
                this.addSignatureConfirmation(sigParts);
            }
            try {
                if (sigParts.size() > 0 && initiatorWrapper != null && this.isRequestor()) {
                    this.doSignature(initiatorWrapper, sigParts, attached);
                } else if (!this.isRequestor()) {
                    TokenWrapper recipientSignatureToken = this.abinding.getRecipientSignatureToken();
                    if (recipientSignatureToken == null) {
                        recipientSignatureToken = this.abinding.getRecipientToken();
                    }
                    if (recipientSignatureToken != null) {
                        this.doSignature(recipientSignatureToken, sigParts, attached);
                    }
                }
            }
            catch (WSSecurityException ex) {
                throw new Fault((Throwable)ex);
            }
            catch (SOAPException ex) {
                throw new Fault((Throwable)ex);
            }
            if (this.isRequestor()) {
                this.doEndorse();
            }
            this.checkForSignatureProtection(encryptionToken, encrBase);
        }
    }

    private void checkForSignatureProtection(Token encryptionToken, WSSecBase encrBase) {
        if (this.abinding.isSignatureProtection()) {
            Element secondRefList;
            ArrayList<WSEncryptionPart> secondEncrParts = new ArrayList<WSEncryptionPart>();
            if (this.mainSigId != null) {
                WSEncryptionPart sigPart = new WSEncryptionPart(this.mainSigId, "Element");
                sigPart.setElement(this.bottomUpElement);
                secondEncrParts.add(sigPart);
            }
            if (this.sigConfList != null && !this.sigConfList.isEmpty()) {
                secondEncrParts.addAll(this.sigConfList);
            }
            if (this.isRequestor()) {
                secondEncrParts.addAll(this.encryptedTokensList);
            }
            if (encryptionToken.isDerivedKeys() && !secondEncrParts.isEmpty()) {
                try {
                    secondRefList = ((WSSecDKEncrypt)encrBase).encryptForExternalRef(null, secondEncrParts);
                    ((WSSecDKEncrypt)encrBase).addExternalRefElement(secondRefList, this.secHeader);
                }
                catch (WSSecurityException ex) {
                    throw new Fault((Throwable)ex);
                }
            }
            if (!secondEncrParts.isEmpty()) {
                try {
                    secondRefList = this.saaj.getSOAPPart().createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
                    this.insertBeforeBottomUp(secondRefList);
                    ((WSSecEncrypt)encrBase).encryptForRef(secondRefList, secondEncrParts);
                }
                catch (WSSecurityException ex) {
                    throw new Fault((Throwable)ex);
                }
            }
        }
    }

    private WSSecBase doEncryption(TokenWrapper recToken, List<WSEncryptionPart> encrParts, boolean externalRef) {
        if (recToken != null && recToken.getToken() != null && encrParts.size() > 0) {
            Token encrToken = recToken.getToken();
            this.policyAsserted((Assertion)recToken);
            this.policyAsserted((Assertion)encrToken);
            AlgorithmSuite algorithmSuite = this.abinding.getAlgorithmSuite();
            if (encrToken.isDerivedKeys()) {
                try {
                    WSSecDKEncrypt dkEncr = new WSSecDKEncrypt(this.wssConfig);
                    if (this.encrKey == null) {
                        this.setupEncryptedKey(recToken, encrToken);
                    }
                    dkEncr.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
                    dkEncr.setParts(encrParts);
                    dkEncr.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    dkEncr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    dkEncr.setDerivedKeyLength(algorithmSuite.getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare((Document)this.saaj.getSOAPPart());
                    this.addDerivedKeyElement(dkEncr.getdktElement());
                    Element refList = dkEncr.encryptForExternalRef(null, encrParts);
                    this.insertBeforeBottomUp(refList);
                    return dkEncr;
                }
                catch (Exception e) {
                    this.policyNotAsserted((Assertion)recToken, e);
                }
            } else {
                try {
                    WSSecEncrypt encr = new WSSecEncrypt(this.wssConfig);
                    encr.setDocument((Document)this.saaj.getSOAPPart());
                    Crypto crypto = this.getEncryptionCrypto(recToken);
                    SecurityToken securityToken = this.getSecurityToken();
                    this.setKeyIdentifierType((WSSecBase)encr, recToken, encrToken);
                    if (!this.isRequestor() && securityToken != null && securityToken.getX509Certificate() != null) {
                        encr.setUseThisCert(securityToken.getX509Certificate());
                    } else {
                        this.setEncryptionUser((WSSecEncryptedKey)encr, recToken, false, crypto);
                    }
                    encr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    encr.setKeyEncAlgo(algorithmSuite.getAsymmetricKeyWrap());
                    encr.prepare((Document)this.saaj.getSOAPPart(), crypto);
                    if (encr.getBSTTokenId() != null) {
                        encr.prependBSTElementToHeader(this.secHeader);
                    }
                    Element encryptedKeyElement = encr.getEncryptedKeyElement();
                    if (externalRef) {
                        Element refList = encr.encryptForRef(null, encrParts);
                        this.insertBeforeBottomUp(refList);
                    } else {
                        Element refList = encr.encryptForRef(null, encrParts);
                        encryptedKeyElement.appendChild(refList);
                    }
                    this.addEncryptedKeyElement(encryptedKeyElement);
                    return encr;
                }
                catch (WSSecurityException e) {
                    this.policyNotAsserted((Assertion)recToken, e.getMessage());
                }
            }
        }
        return null;
    }

    private void assertUnusedTokens(TokenWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        Collection ais = this.aim.getAssertionInfo(wrapper.getName());
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != wrapper) continue;
                ai.setAsserted(true);
            }
        }
        if ((ais = this.aim.getAssertionInfo(wrapper.getToken().getName())) != null) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != wrapper.getToken()) continue;
                ai.setAsserted(true);
            }
        }
    }

    private void doSignature(TokenWrapper wrapper, List<WSEncryptionPart> sigParts, boolean attached) throws WSSecurityException, SOAPException {
        if (!this.isRequestor()) {
            this.assertUnusedTokens(this.abinding.getInitiatorToken());
            this.assertUnusedTokens(this.abinding.getInitiatorEncryptionToken());
            this.assertUnusedTokens(this.abinding.getInitiatorSignatureToken());
        } else {
            this.assertUnusedTokens(this.abinding.getRecipientToken());
            this.assertUnusedTokens(this.abinding.getRecipientEncryptionToken());
            this.assertUnusedTokens(this.abinding.getRecipientSignatureToken());
        }
        Token sigToken = wrapper.getToken();
        sigParts.addAll(this.getSignedParts());
        if (sigParts.isEmpty()) {
            if (!attached && this.includeToken(sigToken.getInclusion())) {
                WSSecSignature sig = this.getSignatureBuilder(wrapper, sigToken, attached, false);
                sig.prependBSTElementToHeader(this.secHeader);
            }
            return;
        }
        if (sigToken.isDerivedKeys()) {
            this.setupEncryptedKey(wrapper, sigToken);
            WSSecDKSign dkSign = new WSSecDKSign(this.wssConfig);
            dkSign.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
            dkSign.setSignatureAlgorithm(this.abinding.getAlgorithmSuite().getSymmetricSignature());
            dkSign.setDerivedKeyLength(this.abinding.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            try {
                dkSign.prepare((Document)this.saaj.getSOAPPart(), this.secHeader);
                if (this.abinding.isTokenProtection()) {
                    WSEncryptionPart ekPart = new WSEncryptionPart(this.encrKey.getId());
                    ekPart.setElement(this.encrKey.getEncryptedKeyElement());
                    sigParts.add(ekPart);
                }
                dkSign.setParts(sigParts);
                List referenceList = dkSign.addReferencesToSign(sigParts, this.secHeader);
                this.addDerivedKeyElement(dkSign.getdktElement());
                if (this.bottomUpElement == null) {
                    dkSign.computeSignature(referenceList, false, null);
                } else {
                    dkSign.computeSignature(referenceList, true, this.bottomUpElement);
                }
                this.bottomUpElement = dkSign.getSignatureElement();
                this.signatures.add(dkSign.getSignatureValue());
                this.mainSigId = dkSign.getSignatureId();
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
        } else {
            WSSecSignature sig = this.getSignatureBuilder(wrapper, sigToken, attached, false);
            if (this.abinding.isTokenProtection() && sig.getBSTTokenId() != null) {
                WSEncryptionPart bstPart = new WSEncryptionPart(sig.getBSTTokenId());
                bstPart.setElement(sig.getBinarySecurityTokenElement());
                sigParts.add(bstPart);
            }
            sig.prependBSTElementToHeader(this.secHeader);
            List referenceList = sig.addReferencesToSign(sigParts, this.secHeader);
            if (this.bottomUpElement == null) {
                sig.computeSignature(referenceList, false, null);
            } else {
                sig.computeSignature(referenceList, true, this.bottomUpElement);
            }
            this.bottomUpElement = sig.getSignatureElement();
            this.signatures.add(sig.getSignatureValue());
            this.mainSigId = sig.getId();
        }
    }

    private void setupEncryptedKey(TokenWrapper wrapper, Token token) throws WSSecurityException {
        if (!this.isRequestor() && token.isDerivedKeys()) {
            if (this.encryptedKeyId != null && this.encryptedKeyValue != null) {
                return;
            }
            List results = CastUtils.cast((List)((List)this.message.getExchange().getInMessage().get((Object)"RECV_RESULTS")));
            if (results != null) {
                this.encryptedKeyId = AsymmetricBindingHandler.getRequestEncryptedKeyId(results);
                this.encryptedKeyValue = AsymmetricBindingHandler.getRequestEncryptedKeyValue(results);
                if (this.encryptedKeyId == null && this.encryptedKeyValue == null) {
                    this.createEncryptedKey(wrapper, token);
                }
            } else {
                this.policyNotAsserted((Assertion)token, "No security results found");
            }
        } else {
            this.createEncryptedKey(wrapper, token);
        }
    }

    public static String getRequestEncryptedKeyId(List<WSHandlerResult> results) {
        for (WSHandlerResult rResult : results) {
            List wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                String encrKeyId = (String)wser.get((Object)"id");
                if (actInt != 4 || encrKeyId == null) continue;
                return encrKeyId;
            }
        }
        return null;
    }

    public static byte[] getRequestEncryptedKeyValue(List<WSHandlerResult> results) {
        for (WSHandlerResult rResult : results) {
            List wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                byte[] decryptedKey = (byte[])wser.get((Object)"secret");
                if (actInt != 4 || decryptedKey == null) continue;
                return decryptedKey;
            }
        }
        return null;
    }

    private void createEncryptedKey(TokenWrapper wrapper, Token token) throws WSSecurityException {
        this.encrKey = this.getEncryptedKeyBuilder(wrapper, token);
        Element bstElem = this.encrKey.getBinarySecurityTokenElement();
        if (bstElem != null) {
            this.encrKey.prependBSTElementToHeader(this.secHeader);
        }
        this.addEncryptedKeyElement(this.encrKey.getEncryptedKeyElement());
        this.encryptedKeyValue = this.encrKey.getEphemeralKey();
        this.encryptedKeyId = this.encrKey.getId();
        this.message.put(WSSecEncryptedKey.class.getName(), (Object)this.encrKey);
    }
}

