/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.security.Principal;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.security.SecurityDomainAdd;
import org.jboss.as.security.SecurityDomainReloadWriteHandler;
import org.jboss.as.security.SecurityDomainRemove;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.security.SecuritySubsystemDescriptions;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.security.CacheableManager;
import org.jboss.security.SimplePrincipal;

public class SecurityDomainResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition CACHE_TYPE = new SimpleAttributeDefinitionBuilder("cache-type", ModelType.STRING, true).build();
    private final boolean registerRuntimeOnly;

    SecurityDomainResourceDefinition(boolean registerRuntimeOnly) {
        super(PathElement.pathElement((String)"security-domain"), SecurityExtension.getResourceDescriptionResolver("security-domain"), (OperationStepHandler)SecurityDomainAdd.INSTANCE, (OperationStepHandler)SecurityDomainRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CACHE_TYPE, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler((AttributeDefinition)CACHE_TYPE));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.registerRuntimeOnly) {
            EnumSet<OperationEntry.Flag> runtimeOnly = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
            resourceRegistration.registerOperationHandler("list-cached-principals", (OperationStepHandler)ListCachePrincipals.INSTANCE, SecuritySubsystemDescriptions.LIST_CACHED_PRINCIPALS, runtimeOnly);
            resourceRegistration.registerOperationHandler("flush-cache", (OperationStepHandler)FlushOperation.INSTANCE, SecuritySubsystemDescriptions.FLUSH_CACHE, runtimeOnly);
        }
    }

    public static ServiceName getSecurityDomainServiceName(PathAddress pathAddress) {
        PathAddress domain = Util.getParentAddressByKey((PathAddress)pathAddress, (String)"security-domain");
        if (domain == null) {
            throw SecurityMessages.MESSAGES.addressDidNotContainSecurityDomain();
        }
        return SecurityDomainService.SERVICE_NAME.append(new String[]{domain.getLastElement().getValue()});
    }

    private static ServiceController<SecurityDomainContext> getSecurityDomainService(OperationContext context, String securityDomain) {
        return context.getServiceRegistry(false).getRequiredService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}));
    }

    static final class FlushOperation
    extends AbstractRuntimeOnlyHandler {
        static final FlushOperation INSTANCE = new FlushOperation();

        FlushOperation() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceController controller;
            ModelNode opAddr = operation.require("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            String securityDomain = address.getLastElement().getValue();
            String principal = null;
            if (operation.hasDefined("principal")) {
                principal = operation.get("principal").asString();
            }
            if ((controller = SecurityDomainResourceDefinition.getSecurityDomainService(context, securityDomain)) != null) {
                this.waitFor(controller);
                SecurityDomainContext sdc = (SecurityDomainContext)controller.getValue();
                CacheableManager manager = (CacheableManager)sdc.getAuthenticationManager();
                if (principal != null) {
                    manager.flushCache((Object)new SimplePrincipal(principal));
                } else {
                    manager.flushCache();
                }
            } else {
                context.getFailureDescription().set("No authentication cache for security domain " + securityDomain + " available");
            }
            context.completeStep();
        }
    }

    static class ListCachePrincipals
    extends AbstractRuntimeOnlyHandler {
        static final ListCachePrincipals INSTANCE = new ListCachePrincipals();

        ListCachePrincipals() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode opAddr = operation.require("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            String securityDomain = address.getLastElement().getValue();
            ServiceController controller = SecurityDomainResourceDefinition.getSecurityDomainService(context, securityDomain);
            if (controller != null) {
                this.waitFor(controller);
                SecurityDomainContext sdc = (SecurityDomainContext)controller.getValue();
                CacheableManager manager = (CacheableManager)sdc.getAuthenticationManager();
                Set cachedPrincipals = manager.getCachedKeys();
                ModelNode result = context.getResult();
                for (Principal principal : cachedPrincipals) {
                    result.add(principal.getName());
                }
                if (!result.isDefined()) {
                    result.setEmptyList();
                }
            } else {
                context.getFailureDescription().set("No authentication cache for security domain " + securityDomain + " available");
            }
            context.completeStep();
        }
    }
}

