/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.io.Console;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportCollector;
import org.jboss.as.jdr.SosInterpreter;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;

public class JdrReportService
implements JdrReportCollector,
Service<JdrReportCollector> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jdr", "collector"});
    private final InjectedValue<ServerEnvironment> serverEnvironmentValue = new InjectedValue();
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private ExecutorService executorService;
    private ServerEnvironment serverEnvironment;
    private ModelControllerClient controllerClient;

    public static ServiceController<JdrReportCollector> addService(ServiceTarget target, ServiceVerificationHandler verificationHandler) {
        JdrReportService service = new JdrReportService();
        return target.addService(SERVICE_NAME, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.serverEnvironmentValue).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.modelControllerValue).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public JdrReport standaloneCollect(String host, String port) throws OperationFailedException {
        Console cons = System.console();
        String username = null;
        String password = null;
        if (host == null) {
            host = "localhost";
        }
        if (port == null) {
            port = "9990";
        }
        boolean must_auth = false;
        try {
            URL managementApi = new URL("http://" + NetworkUtils.formatPossibleIpv6Address((String)host) + ":" + port + "/management");
            HttpURLConnection conn = (HttpURLConnection)managementApi.openConnection();
            int code = conn.getResponseCode();
            if (code != 200) {
                must_auth = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (must_auth && cons != null) {
            username = cons.readLine("Management username: ", new Object[0]);
            password = String.valueOf(cons.readPassword("Management password: ", new Object[0]));
        }
        SosInterpreter interpreter = new SosInterpreter();
        return interpreter.collect(username, password, host, port);
    }

    @Override
    public JdrReport collect() throws OperationFailedException {
        SosInterpreter interpreter = new SosInterpreter();
        this.serverEnvironment = (ServerEnvironment)this.serverEnvironmentValue.getValue();
        interpreter.setJbossHomeDir(this.serverEnvironment.getHomeDir().getAbsolutePath());
        interpreter.setReportLocationDir(this.serverEnvironment.getServerTempDir().getAbsolutePath());
        interpreter.setControllerClient(this.controllerClient);
        interpreter.setHostControllerName(this.serverEnvironment.getHostControllerName());
        interpreter.setServerName(this.serverEnvironment.getServerName());
        return interpreter.collect();
    }

    public synchronized void start(StartContext context) throws StartException {
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("JdrReportCollector-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
        this.serverEnvironment = (ServerEnvironment)this.serverEnvironmentValue.getValue();
        this.controllerClient = ((ModelController)this.modelControllerValue.getValue()).createClient((Executor)this.executorService);
    }

    public synchronized void stop(StopContext context) {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public JdrReportService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

