/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.protocol.v1;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

public class ReadUtil {
    static final MarshallerFactory marshallerFactory = Marshalling.getProvidedMarshallerFactory("river");

    static Unmarshaller prepareForUnMarshalling(final DataInput dataInput) throws IOException {
        Unmarshaller unmarshaller = ReadUtil.getUnMarshaller(marshallerFactory);
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    byte b = dataInput.readByte();
                    return b & 0xFF;
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
        };
        ByteInput byteInput = Marshalling.createByteInput(is);
        unmarshaller.start(byteInput);
        return unmarshaller;
    }

    static Unmarshaller getUnMarshaller(MarshallerFactory marshallerFactory) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        return marshallerFactory.createUnmarshaller(marshallingConfiguration);
    }

    static {
        if (marshallerFactory == null) {
            throw new RuntimeException("Could not find a marshaller factory for river marshalling strategy");
        }
    }
}

