/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.ra.IdDecoratedMetadata;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.XsdString;

public class RequiredConfigProperty
implements IdDecoratedMetadata,
CopyableMetaData {
    private static final long serialVersionUID = 4299927051352998447L;
    private final ArrayList<LocalizedXsdString> description;
    private final XsdString configPropertyName;
    private final String id;

    public RequiredConfigProperty(List<LocalizedXsdString> description, XsdString configPropertyName, String id) {
        if (description != null) {
            this.description = new ArrayList(description.size());
            this.description.addAll(description);
        } else {
            this.description = new ArrayList(0);
        }
        this.configPropertyName = configPropertyName;
        this.id = id;
    }

    public List<LocalizedXsdString> getDescriptions() {
        return this.description == null ? null : Collections.unmodifiableList(this.description);
    }

    public XsdString getConfigPropertyName() {
        return this.configPropertyName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configPropertyName == null ? 0 : this.configPropertyName.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequiredConfigProperty)) {
            return false;
        }
        RequiredConfigProperty other = (RequiredConfigProperty)obj;
        if (this.configPropertyName == null ? other.configPropertyName != null : !this.configPropertyName.equals(other.configPropertyName)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<required-config-property");
        if (this.id != null) {
            sb.append(" ").append((Object)Attribute.ID).append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (!XsdString.isNull(this.configPropertyName)) {
            sb.append("<").append((Object)Tag.CONFIG_PROPERTY_NAME).append(">");
            sb.append(this.configPropertyName);
            sb.append("</").append((Object)Tag.CONFIG_PROPERTY_NAME).append(">");
        }
        sb.append("</required-config-property>");
        return sb.toString();
    }

    @Override
    public CopyableMetaData copy() {
        return new RequiredConfigProperty(CopyUtil.cloneList(this.description), CopyUtil.clone(this.configPropertyName), CopyUtil.cloneString(this.id));
    }

    public static enum Attribute {
        ID("id");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        DESCRIPTION("description"),
        CONFIG_PROPERTY_NAME("config-property-name");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

