/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.lang.reflect.Field;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.injection.FieldInjectionPoint;
import org.jboss.as.weld.injection.SecurityActions;
import org.jboss.weld.manager.BeanManagerImpl;

final class InjectableField {
    private final Field field;
    private final Bean<?> bean;
    private final FieldInjectionPoint injectionPoint;

    public InjectableField(Field field, Bean<?> bean, FieldInjectionPoint injectionPoint) {
        this.bean = bean;
        this.field = field;
        this.injectionPoint = injectionPoint;
        SecurityActions.setAccessible(field);
    }

    public void inject(Object instance, BeanManagerImpl beanManager, CreationalContext<?> ctx) {
        try {
            Object value = beanManager.getReference((InjectionPoint)this.injectionPoint, this.bean, ctx);
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw WeldMessages.MESSAGES.couldNotInjectField(this.field, instance.getClass(), e);
        }
    }
}

