/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.weld.injection.WeldManagedReference;
import org.jboss.as.weld.injection.WeldManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class WeldInjectionInterceptor
implements Interceptor {
    final AtomicReference<ManagedReference> targetReference;
    final Map<Class<?>, AtomicReference<ManagedReference>> interceptors;
    final WeldManagedReferenceFactory managedReferenceFactory;

    public WeldInjectionInterceptor(AtomicReference<ManagedReference> targetReference, Map<Class<?>, AtomicReference<ManagedReference>> interceptors, WeldManagedReferenceFactory managedReferenceFactory) {
        this.targetReference = targetReference;
        this.interceptors = interceptors;
        this.managedReferenceFactory = managedReferenceFactory;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        ManagedReference managedReference = this.targetReference.get();
        if (managedReference instanceof WeldManagedReference) {
            WeldManagedReference reference = (WeldManagedReference)managedReference;
            reference.getInjectionTarget().inject(this.targetReference.get().getInstance(), reference.getContext());
            for (Map.Entry<Class<?>, AtomicReference<ManagedReference>> entry : this.interceptors.entrySet()) {
                ManagedReference instance = entry.getValue().get();
                if (instance == null) continue;
                reference.injectInterceptor(entry.getKey(), instance.getInstance());
            }
        } else if (this.managedReferenceFactory != null) {
            ManagedReference newReference = this.managedReferenceFactory.injectExistingReference(managedReference);
            this.targetReference.set(newReference);
        }
        return context.proceed();
    }

    public static class Factory
    implements InterceptorFactory {
        final ComponentConfiguration configuration;
        final Set<Class<?>> interceptorClasses;

        public Factory(ComponentConfiguration configuration, Set<Class<?>> interceptorClasses) {
            this.configuration = configuration;
            this.interceptorClasses = interceptorClasses;
        }

        public Interceptor create(InterceptorFactoryContext context) {
            AtomicReference targetReference = (AtomicReference)context.getContextData().get(BasicComponentInstance.INSTANCE_KEY);
            HashMap interceptors = new HashMap();
            for (Class<?> clazz : this.interceptorClasses) {
                AtomicReference interceptor = (AtomicReference)context.getContextData().get(clazz);
                if (interceptor == null) continue;
                interceptors.put(clazz, interceptor);
            }
            WeldManagedReferenceFactory managedReferenceFactory = null;
            if (this.configuration.getInstanceFactory() instanceof WeldManagedReferenceFactory) {
                managedReferenceFactory = (WeldManagedReferenceFactory)this.configuration.getInstanceFactory();
            }
            return new WeldInjectionInterceptor(targetReference, interceptors, managedReferenceFactory);
        }
    }
}

