/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.oracle;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;
import org.jboss.logging.Logger;

public class OracleValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 5379340663276548636L;
    private static Logger log = Logger.getLogger(OracleValidConnectionChecker.class);
    private Integer pingTimeOut = 5;

    @Override
    public SQLException isValidConnection(Connection c) {
        Object[] params = new Object[]{this.pingTimeOut};
        try {
            Method ping = c.getClass().getMethod("pingDatabase", Integer.TYPE);
            ping.setAccessible(true);
            Integer status = (Integer)ping.invoke((Object)c, params);
            if (status == null || status < 0) {
                return new SQLException("pingDatabase failed status=" + status);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected error in pingDatabase", (Throwable)e);
        }
        return null;
    }

    public Integer getPingTimeOut() {
        return this.pingTimeOut;
    }

    public void setPingTimeOut(Integer pingTimeOut) {
        this.pingTimeOut = pingTimeOut;
    }
}

