/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import org.apache.catalina.ha.backend.HeartbeatListener;
import org.apache.catalina.ha.backend.Sender;
import org.jboss.logging.Logger;

public class MultiCastSender
implements Sender {
    private static Logger log = Logger.getLogger(HeartbeatListener.class);
    HeartbeatListener config = null;
    MulticastSocket s = null;
    InetAddress group = null;

    @Override
    public void init(HeartbeatListener config) throws Exception {
        this.config = config;
    }

    @Override
    public int send(String mess) throws Exception {
        byte[] buf;
        if (this.s == null) {
            try {
                this.group = InetAddress.getByName(this.config.getGroup());
                if (this.config.host != null) {
                    InetAddress addr = InetAddress.getByName(this.config.host);
                    InetSocketAddress addrs = new InetSocketAddress(addr, this.config.getMultiport());
                    this.s = new MulticastSocket(addrs);
                } else {
                    this.s = new MulticastSocket(this.config.getMultiport());
                }
                this.s.setTimeToLive(this.config.getTtl());
                this.s.joinGroup(this.group);
            }
            catch (Exception ex) {
                log.error((Object)("Unable to use multicast: " + ex));
                this.s = null;
                return -1;
            }
        }
        try {
            buf = mess.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            buf = mess.getBytes();
        }
        DatagramPacket data = new DatagramPacket(buf, buf.length, this.group, this.config.getMultiport());
        try {
            this.s.send(data);
        }
        catch (Exception ex) {
            log.error((Object)("Unable to send colllected load information: " + ex));
            this.s.close();
            this.s = null;
            return -1;
        }
        return 0;
    }
}

