/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.jaxb.PrintUDDI;
import org.apache.juddi.v3.client.config.Property;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2UDDI {
    private Log log = LogFactory.getLog(this.getClass());
    private String keyDomainURI;
    private String businessKey;
    private String lang;
    private UDDIClerk clerk = null;
    private Properties properties = null;
    private URLLocalizer urlLocalizer;

    public WSDL2UDDI(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties) {
        this.clerk = clerk;
        this.urlLocalizer = urlLocalizer;
        this.properties = properties;
        this.keyDomainURI = "uddi:" + properties.getProperty("keyDomain") + ":";
        this.businessKey = Property.getBusinessKey(properties);
        this.lang = properties.getProperty("lang", "en:");
    }

    public BindingTemplate register(QName serviceQName, String portName, URL serviceUrl, Definition wsdlDefinition) throws RemoteException, ConfigurationException, TransportException, WSDLException {
        String genericWSDLURL = wsdlDefinition.getDocumentBaseURI();
        String serviceKey = Property.getServiceKey(this.properties, serviceQName);
        BusinessService service = this.lookupService(serviceKey);
        if (service == null) {
            ArrayList<TModel> tModels = new ArrayList<TModel>();
            Map portTypes = wsdlDefinition.getAllPortTypes();
            tModels.addAll(this.createWSDLPortTypeTModels(genericWSDLURL, portTypes));
            Map bindings = wsdlDefinition.getAllBindings();
            tModels.addAll(this.createWSDLBindingTModels(genericWSDLURL, bindings));
            for (TModel tModel : tModels) {
                this.clerk.register(tModel);
            }
            service = this.createBusinessService(serviceQName, wsdlDefinition);
            this.clerk.register(service);
        }
        BindingTemplate binding = this.createWSDLBinding(serviceQName, portName, serviceUrl, wsdlDefinition);
        this.clerk.register(binding);
        return binding;
    }

    public String unRegister(QName serviceName, String portName, URL serviceUrl) throws RemoteException, ConfigurationException, TransportException {
        String serviceKey = Property.getServiceKey(this.properties, serviceName);
        BusinessService service = this.lookupService(serviceKey);
        boolean isRemoveServiceIfNoTemplates = true;
        String bindingKey = Property.getBindingKey(this.properties, serviceName, portName, serviceUrl);
        for (BindingTemplate bindingTemplate : service.getBindingTemplates().getBindingTemplate()) {
            if (!bindingKey.equals(bindingTemplate.getBindingKey())) continue;
            this.clerk.unRegisterBinding(bindingKey);
            if (service.getBindingTemplates().getBindingTemplate().size() != 1 || !isRemoveServiceIfNoTemplates) continue;
            this.clerk.unRegisterService(serviceKey);
            if (bindingTemplate.getTModelInstanceDetails() == null || bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfo() == null) continue;
            for (TModelInstanceInfo tModelInstanceInfo : bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfo()) {
                String tModelKey = tModelInstanceInfo.getTModelKey();
                TModelDetail tModelDetail = this.clerk.getTModelDetail(tModelKey);
                if (tModelDetail.getTModel() == null || tModelDetail.getTModel().size() <= 0) continue;
                for (TModel tModel : tModelDetail.getTModel()) {
                    this.clerk.unRegisterTModel(tModel.getTModelKey());
                }
            }
        }
        return serviceKey;
    }

    public String getKeyDomainURI() {
        return this.keyDomainURI;
    }

    public void setKeyDomain(String keyDomainURI) {
        this.keyDomainURI = keyDomainURI;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Set<TModel> createWSDLBindingTModels(String wsdlURL, Map<QName, Binding> bindings) throws WSDLException {
        HashSet<TModel> tModels = new HashSet<TModel>();
        for (QName qName : bindings.keySet()) {
            String localpart = qName.getLocalPart();
            String namespace = qName.getNamespaceURI();
            TModel tModel = new TModel();
            tModel.setTModelKey(this.keyDomainURI + localpart);
            Name name = new Name();
            name.setLang(this.lang);
            name.setValue(localpart);
            tModel.setName(name);
            OverviewURL overviewURL = new OverviewURL();
            overviewURL.setUseType(AccessPointType.WSDL_DEPLOYMENT.toString());
            overviewURL.setValue(wsdlURL);
            OverviewDoc overviewDoc = new OverviewDoc();
            overviewDoc.setOverviewURL(overviewURL);
            tModel.getOverviewDoc().add(overviewDoc);
            CategoryBag categoryBag = new CategoryBag();
            if (namespace != null && !"".equals(namespace)) {
                KeyedReference namespaceReference = this.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:binding:namespace", namespace);
                categoryBag.getKeyedReference().add(namespaceReference);
            }
            KeyedReference typesReference = this.newKeyedReference("uddi:uddi.org:wsdl:types", "uddi-org:wsdl:types", "binding");
            categoryBag.getKeyedReference().add(typesReference);
            Binding binding = bindings.get(qName);
            String portTypeKey = this.keyDomainURI + binding.getPortType().getQName().getLocalPart();
            KeyedReference namespaceReference = this.newKeyedReference("uddi:uddi.org:wsdl:porttypereference", "uddi-org:wsdl:portTypeReference", portTypeKey);
            categoryBag.getKeyedReference().add(namespaceReference);
            KeyedReference typesReferenceBackwardsCompatible = this.newKeyedReference("uddi:uddi.org:categorization:types", "uddi-org:types", "wsdlSpec");
            categoryBag.getKeyedReference().add(typesReferenceBackwardsCompatible);
            for (Object object : binding.getExtensibilityElements()) {
                if (SOAPBinding.class.isAssignableFrom(object.getClass())) {
                    SOAPBinding soapBinding = (SOAPBinding)object;
                    KeyedReference soapProtocol = this.newKeyedReference("uddi:uddi.org:wsdl:categorization:protocol", "uddi-org:protocol:soap", "uddi:uddi.org:protocol:soap");
                    categoryBag.getKeyedReference().add(soapProtocol);
                    if ("http://schemas.xmlsoap.org/soap/http".equals(soapBinding.getTransportURI())) {
                        KeyedReference httpTransport = this.newKeyedReference("uddi:uddi.org:wsdl:categorization:transport", "uddi-org:http", "uddi:uddi.org:transport:http");
                        categoryBag.getKeyedReference().add(httpTransport);
                        continue;
                    }
                    if (soapBinding.getTransportURI() == null) continue;
                    this.log.warn((Object)"not implemented");
                    continue;
                }
                if (!object.getClass().isInstance(HTTPBinding.class)) continue;
                KeyedReference soapProtocol = this.newKeyedReference("uddi:uddi.org:wsdl:categorization:protocol", "uddi-org:protocol:http", "uddi:uddi.org:protocol:http");
                categoryBag.getKeyedReference().add(soapProtocol);
            }
            tModel.setCategoryBag(categoryBag);
            tModels.add(tModel);
        }
        return tModels;
    }

    public Set<TModel> createWSDLPortTypeTModels(String wsdlURL, Map<QName, PortType> portTypes) throws WSDLException {
        HashSet<TModel> tModels = new HashSet<TModel>();
        for (QName qName : portTypes.keySet()) {
            TModel tModel = new TModel();
            String localpart = qName.getLocalPart();
            String namespace = qName.getNamespaceURI();
            tModel.setTModelKey(this.keyDomainURI + localpart);
            Name name = new Name();
            name.setLang(this.lang);
            name.setValue(localpart);
            tModel.setName(name);
            OverviewURL overviewURL = new OverviewURL();
            overviewURL.setUseType(AccessPointType.WSDL_DEPLOYMENT.toString());
            overviewURL.setValue(wsdlURL);
            OverviewDoc overviewDoc = new OverviewDoc();
            overviewDoc.setOverviewURL(overviewURL);
            tModel.getOverviewDoc().add(overviewDoc);
            CategoryBag categoryBag = new CategoryBag();
            KeyedReference typesReference = this.newKeyedReference("uddi:uddi.org:wsdl:types", "uddi-org:wsdl:types", "portType");
            categoryBag.getKeyedReference().add(typesReference);
            if (namespace != null && !"".equals(namespace)) {
                KeyedReference namespaceReference = this.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:porttype:namespace", namespace);
                categoryBag.getKeyedReference().add(namespaceReference);
            }
            tModel.setCategoryBag(categoryBag);
            tModels.add(tModel);
        }
        return tModels;
    }

    protected KeyedReference newKeyedReference(String tModelKey, String value) {
        KeyedReference typesReference = new KeyedReference();
        typesReference.setTModelKey(tModelKey);
        typesReference.setKeyValue(value);
        return typesReference;
    }

    protected KeyedReference newKeyedReference(String tModelKey, String keyName, String value) {
        KeyedReference typesReference = new KeyedReference();
        typesReference.setTModelKey(tModelKey);
        typesReference.setKeyName(keyName);
        typesReference.setKeyValue(value);
        return typesReference;
    }

    public FindTModel createFindBindingTModelForPortType(String portType, String namespace) {
        FindTModel findTModel = new FindTModel();
        CategoryBag categoryBag = new CategoryBag();
        if (namespace != null && namespace != "") {
            KeyedReference namespaceReference = this.newKeyedReference("uddi:uddi.org:xml:namespace", namespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference bindingReference = this.newKeyedReference("uddi:uddi.org:wsdl:types", "binding");
        categoryBag.getKeyedReference().add(bindingReference);
        KeyedReference portTypeReference = this.newKeyedReference("uddi:uddi.org:wsdl:porttypereference", portType);
        categoryBag.getKeyedReference().add(portTypeReference);
        findTModel.setCategoryBag(categoryBag);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)new PrintUDDI().print((Object)findTModel));
        }
        return findTModel;
    }

    public FindTModel createFindPortTypeTModelForPortType(String portType, String namespace) {
        FindTModel findTModel = new FindTModel();
        Name name = new Name();
        name.setLang(this.lang);
        name.setValue(portType);
        findTModel.setName(name);
        CategoryBag categoryBag = new CategoryBag();
        if (namespace != null && namespace != "") {
            KeyedReference namespaceReference = this.newKeyedReference("uddi:uddi.org:xml:namespace", namespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference bindingReference = this.newKeyedReference("uddi:uddi.org:wsdl:types", "portType");
        categoryBag.getKeyedReference().add(bindingReference);
        KeyedReference portTypeReference = this.newKeyedReference("uddi:uddi.org:wsdl:porttypereference", portType);
        categoryBag.getKeyedReference().add(portTypeReference);
        findTModel.setCategoryBag(categoryBag);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)new PrintUDDI().print((Object)findTModel));
        }
        return findTModel;
    }

    public BusinessService lookupService(String serviceKey) throws RemoteException, ConfigurationException, TransportException {
        BusinessService service = this.clerk.findService(serviceKey);
        return service;
    }

    public BusinessService createBusinessService(QName serviceQName, Definition wsdlDefinition) {
        Element docElement;
        this.log.debug((Object)("Constructing Service UDDI Information for " + serviceQName));
        BusinessService service = new BusinessService();
        service.setBusinessKey(this.businessKey);
        service.setServiceKey(Property.getServiceKey(this.properties, serviceQName));
        String serviceDescription = this.properties.getProperty("serviceDescription", "Default service description when no <wsdl:document> element is defined inside the <wsdl:service> element.");
        if (wsdlDefinition.getService(serviceQName) != null && (docElement = wsdlDefinition.getService(serviceQName).getDocumentationElement()) != null && docElement.getTextContent() != null) {
            serviceDescription = docElement.getTextContent();
        }
        Description description = new Description();
        description.setLang(this.lang);
        description.setValue(serviceDescription);
        service.getDescription().add(description);
        Name sName = new Name();
        sName.setLang(this.lang);
        sName.setValue(serviceQName.getLocalPart());
        service.getName().add(sName);
        CategoryBag categoryBag = new CategoryBag();
        String namespace = serviceQName.getNamespaceURI();
        if (namespace != null && namespace != "") {
            KeyedReference namespaceReference = this.newKeyedReference("uddi:uddi.org:xml:namespace", "service namespace", namespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference serviceReference = this.newKeyedReference("uddi:uddi.org:wsdl:types", "WSDL type", "service");
        categoryBag.getKeyedReference().add(serviceReference);
        KeyedReference localNameReference = this.newKeyedReference("uddi:uddi.org:xml:localname", "service local name", serviceQName.getLocalPart());
        categoryBag.getKeyedReference().add(localNameReference);
        service.setCategoryBag(categoryBag);
        return service;
    }

    public BindingTemplate createWSDLBinding(QName serviceQName, String portName, URL serviceUrl, Definition wsdlDefinition) {
        BindingTemplate bindingTemplate = new BindingTemplate();
        bindingTemplate.setServiceKey(Property.getServiceKey(this.properties, serviceQName));
        String bindingKey = Property.getBindingKey(this.properties, serviceQName, portName, serviceUrl);
        bindingTemplate.setBindingKey(bindingKey);
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setUseType(AccessPointType.END_POINT.toString());
        accessPoint.setValue(this.urlLocalizer.rewrite(serviceUrl));
        bindingTemplate.setAccessPoint(accessPoint);
        Service service = wsdlDefinition.getService(serviceQName);
        if (service != null) {
            TModelInstanceDetails tModelInstanceDetails = new TModelInstanceDetails();
            Port port = service.getPort(portName);
            if (port != null) {
                Binding binding = port.getBinding();
                String bindingDescription = this.properties.getProperty("bindingDescription", "Default binding description when no <wsdl:document> element is defined inside the <wsdl:binding> element.");
                Element docElement = binding.getDocumentationElement();
                if (docElement != null && docElement.getTextContent() != null) {
                    bindingDescription = docElement.getTextContent();
                }
                Description description = new Description();
                description.setLang(this.lang);
                description.setValue(bindingDescription);
                bindingTemplate.getDescription().add(description);
                TModelInstanceInfo tModelInstanceInfoBinding = new TModelInstanceInfo();
                tModelInstanceInfoBinding.setTModelKey(this.keyDomainURI + binding.getQName().getLocalPart());
                InstanceDetails instanceDetails = new InstanceDetails();
                instanceDetails.setInstanceParms(portName);
                tModelInstanceInfoBinding.setInstanceDetails(instanceDetails);
                Description descriptionB = new Description();
                descriptionB.setLang(this.lang);
                descriptionB.setValue("The wsdl:binding that this wsdl:port implements. " + bindingDescription + " The instanceParms specifies the port local name.");
                tModelInstanceInfoBinding.getDescription().add(descriptionB);
                tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoBinding);
                PortType portType = binding.getPortType();
                TModelInstanceInfo tModelInstanceInfoPortType = new TModelInstanceInfo();
                tModelInstanceInfoPortType.setTModelKey(this.keyDomainURI + portType.getQName().getLocalPart());
                String portTypeDescription = "";
                docElement = portType.getDocumentationElement();
                if (docElement != null && docElement.getTextContent() != null) {
                    portTypeDescription = docElement.getTextContent();
                }
                Description descriptionPT = new Description();
                descriptionPT.setLang(this.lang);
                descriptionPT.setValue("The wsdl:portType that this wsdl:port implements." + portTypeDescription);
                tModelInstanceInfoPortType.getDescription().add(descriptionPT);
                tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoPortType);
                bindingTemplate.setTModelInstanceDetails(tModelInstanceDetails);
            } else {
                this.log.error((Object)("Could not find Port with portName: " + portName));
            }
        } else {
            this.log.error((Object)("Could not find Service with serviceName: " + serviceQName.getLocalPart()));
        }
        return bindingTemplate;
    }
}

